package urlinfo

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
}

type Error string

func (e Error) Error() string {
	return "url info error: " + string(e)
}

type URLInfoType struct{}

func (URLInfoType) Type() string { return "url_info" }

type URLInfoSubType struct{}

func (URLInfoSubType) SubType() string { return "url_info" }

type URLInfoWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	URLInfoType
	URLInfoSubType
}

func (class Class) Name() string { return URLInfoWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

func (class Class) Extend() (w common.Widget, err error) {
	urlInfo, err := class.getIexUrlsInfo()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex urls info convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}
	attributes := urlInfo.getUrlsAttributes()
	if len(attributes) == 0 {
		class.Logger.Error(class.Name(), "no valid urls info in fact")
		return nil, nil
	}
	var controls []common.Control
	for _, attributesOneURL := range attributes {
		controls = append(controls, common.MakeRichPreviewControl(attributesOneURL))
	}
	w = &URLInfoWidget{}
	w.Init(class.Fact.Envelope.Mid, controls, nil, "", "")
	return
}
