package urlinfo

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type URLInfo struct {
	common.IexDict
}

func (class Class) getIexUrlsInfo() (res URLInfo, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = URLInfo{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "urls_info" {
			return
		}
	}
	return URLInfo{}, Error("no urls info in iex")
}

func (info URLInfo) getUrlsAttributes() (res []common.Attributes) {
	if arr, ok := info.GetSomething("urls_info").([]interface{}); ok {
		for _, elem := range arr {
			if urlsMap, ok := elem.(map[string]interface{}); ok {
				url, ok1 := urlsMap["url"].(string)
				title, ok2 := urlsMap["title"].(string)
				favicon, ok3 := urlsMap["favicon"].(string)
				if ok1 && ok2 && ok3 {
					attrs := common.Attributes{}
					attrs["url"] = url
					attrs["title"] = title
					attrs["favicon"] = favicon
					if requestURL, ok := urlsMap["request_url"].(string); ok {
						attrs["request_url"] = requestURL
					}
					if urlMeta, ok := urlsMap["url_meta"].(map[string]interface{}); ok {
						attrs["url_meta"] = urlMeta
					}
					if snippet, ok := urlsMap["snippet"].(string); ok {
						attrs["snippet"] = snippet
					}
					res = append(res, attrs)
				}
			}
		}
	}
	return
}
