package widgets

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/future"
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"strconv"
	"time"
)

type Widgets struct {
	Cfg Config
}

func logStats(l logger.Interface, facts int, classes int, errs []error) {
	timeoutErrors, otherErrors := getErrorCountsByType(errs)
	if timeoutErrors+otherErrors > 0 {
		l.DebugExtra("list", "enrich loss stats", logger.Extra{
			"facts":            strconv.Itoa(facts),
			"classes":          strconv.Itoa(classes),
			"errors":           strconv.Itoa(otherErrors),
			"enrich_timed_out": strconv.Itoa(timeoutErrors)})
	}
}

func logEach(l logger.Interface, w common.Widget) {
	l.DebugExtra("list", "stat each", logger.Extra{
		"mid":     w.Mid(),
		"type":    w.Type(),
		"subtype": w.SubType()})
}

func getErrorCountsByType(errs []error) (timeoutErrorCount int, otherErrorCount int) {
	for _, e := range errs {
		if _, ok := e.(future.TimeoutError); ok {
			timeoutErrorCount++
		} else {
			otherErrorCount++
		}
	}
	return
}

func (w Widgets) Enrich(facts []iex.Fact, l logger.Interface, c client.Interface, r request.Interface) (widgets []common.Widget, lastErr error) {
	group := future.FunctorGroup{}
	for _, fact := range facts {
		classes := w.classify(w.Cfg, fact, l, c, r)
		for _, class := range classes {
			l.Info("list", "classified type "+class.Name())
			classLocal := class
			group = append(group, func() (interface{}, error) {
				return classLocal.Extend()
			})
		}
	}
	f := group.Async()
	res, err := f.GetTimed(time.Duration(w.Cfg.Timeout))
	logStats(l, len(facts), len(group), err)
	for _, widget := range res {
		w := widget.(common.Widget)
		logEach(l, w)
		widgets = append(widgets, w)
	}
	if len(err) > 0 {
		lastErr = err[len(err)-1]
	}
	return
}
