package yandexpayment

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
}

type Error string

func (e Error) Error() string {
	return "yandex payment error: " + string(e)
}

func (class Class) Name() string { return YandexPaymentWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

type YandexPaymentType struct{}

func (YandexPaymentType) Type() string { return "yandex_payment" }

type YandexPaymentSubType struct{}

func (YandexPaymentSubType) SubType() string { return "yandex_payment" }

type YandexPaymentWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	YandexPaymentType
	YandexPaymentSubType
}

func (class Class) Extend() (w common.Widget, err error) {
	from := class.Fact.Envelope.FromDisplayName
	color := class.Cfg.Logo.LogoColorDefault
	zubchiki := class.Cfg.Logo.Zubchiki
	logo := common.MakeLogoControl(from, "", color, zubchiki)
	w = &YandexPaymentWidget{}
	w.Init(class.Fact.Envelope.Mid, []common.Control{logo}, nil, "", "")
	return
}
