#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

./check_its_status.py || exit 1

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/ljinx_service
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

source gc_args.sh

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=$BSCONFIG_IDIR/ljinx_service \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.ljinx.Ljinx $BSCONFIG_IDIR/ljinx.conf