package fuzz

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	"strconv"
	. "strings"
)

type Context struct {
	Folders        []string
	Username       Email
	Password       Password
	Flags          Flags
	PermanentFlags []string
	Exists         int
	UuidNext       uint64
	UuidVelidity   uint64
}

/*
3 OK LOGIN Completed.
4 SELECT INBOX
* FLAGS (\Answered \Seen \Draft \Deleted $Forwarded)
* 340 EXISTS
* 0 RECENT
* OK [PERMANENTFLAGS (\Answered \Seen \Draft \Flagged \Deleted $Forwarded \*)] Limited
* OK [UIDNEXT 39909] Ok
* OK [UIDVALIDITY 1527131879] Ok
4 OK [READ-WRITE] SELECT Completed.
*/
func NewContext(username Email, password Password) Context {
	return Context{
		Folders:        []string{"INBOX"},
		Username:       username,
		Password:       password,
		Flags:          make(Flags, 0),
		PermanentFlags: make([]string, 0),
	}
}

func (c *Context) TryApply(line string) bool {
	switch {
	case HasPrefix(line, "* FLAGS"):
		//* FLAGS (\Answered \Seen \Draft \Deleted $Forwarded)
		line = ReplaceAll(line, "* FLAGS ", "")
		line = ReplaceAll(line, "(", "")
		line = ReplaceAll(line, ")", "")
		for _, f := range Split(line, " ") {
			c.Flags = append(c.Flags, Flag{BasicStringArg: BasicStringArg(f)})
		}
	case HasPrefix(line, "*") && HasSuffix(line, "EXISTS"):
		//* 340 EXISTS
		if n, err := strconv.Atoi(Split(line, " ")[1]); err == nil {
			c.Exists = n
		}
	case HasPrefix(line, "* OK [PERMANENTFLAGS "):
		line = ReplaceAll(line, "* OK [PERMANENTFLAGS ", "")
		line = ReplaceAll(line, "] Limited", "")
		line = ReplaceAll(line, "(", "")
		line = ReplaceAll(line, ")", "")
		c.PermanentFlags = Split(line, " ")
		//* OK [PERMANENTFLAGS (\Answered \Seen \Draft \Flagged \Deleted $Forwarded \*)] Limited
	case HasPrefix(line, "* OK [UIDNEXT "):
		//* OK [UIDNEXT 39909] Ok
		line = ReplaceAll(line, "* OK [UIDNEXT ", "")
		if n, err := strconv.Atoi(Split(line, "]")[0]); err == nil {
			c.UuidNext = uint64(n)
		}
	case HasPrefix(line, "OK [UIDVALIDITY "):
		//* OK [UIDVALIDITY 1527131879] Ok
		line = ReplaceAll(line, "OK [UIDVALIDITY ", "")
		if n, err := strconv.Atoi(Split(line, "]")[0]); err == nil {
			c.UuidVelidity = uint64(n)
		}
	case HasPrefix(line, "* LIST "):
		//line:  * LIST (\Unmarked \HasNoChildren \Sent) "|" "&BB4EQgQ,BEAEMAQyBDsENQQ9BD0ESwQ1-"
		a := Split(line, " ")
		folder := a[len(a)-1]
		if HasPrefix(folder, "\"") && HasSuffix(folder, "\"") {
			folder = TrimPrefix(folder, "\"")
			folder = TrimSuffix(folder, "\"")
		}

		c.Folders = append(c.Folders, folder)
	}
	return false
}
