package naughty

import (
	"bufio"
	"io/ioutil"
	"os"
	"path/filepath"
)

func init() {
	path := os.Getenv("NAUGHTY_FILES")
	if path == "" {
		path = "./corpus/"
	}
	files, err := ioutil.ReadDir(path)
	if err != nil {
		panic("can;t load strings")
	}

	for _, f := range files {
		if arr, err := loadFile(filepath.Join(path, f.Name())); err == nil {
			Strings = append(Strings, arr...)
		} else {
			return
		}
	}

}

func loadFile(path string) (result []string, err error) {
	var of *os.File

	if of, err = os.Open(path); err != nil {
		return
	}

	defer func(file *os.File) {
		if file != nil {
			if err := file.Close(); err != nil {
				panic(err)
			}
		}
	}(of)

	scanner := bufio.NewScanner(of)
	for scanner.Scan() {
		result = append(result, scanner.Text())
	}

	if err = scanner.Err(); err != nil {
		return
	}
	return
}

var Emails = []string{
	"prettyandsimple@example.com",
	"very.common@example.com",
	"disposable.style.email.with+symbol@example.com",
	"other.email-with-dash@example.com",
	"fully-qualified-domain@example.com",
	"x@example.com",
	"\"very.unusual.@.unusual.com\"@example.com",
	"\"very.(),:;<>[]\\\".VERY.\"very@\\ \"very\".unusual\"@strange.example.com",
	"example-indeed@strange-example.com",
	"admin@mailserver1",
	"/#!$%&'*+-/=?^_`{}|~@example.org",
	"\"()<>[]:,;@\\\\\"!#$%&'-/=?^_`{}| ~.a\"@example.org",
	"\" \"@example.org",
	"example@s.solutions",
	"user@localserver",
	"user@tt",
	"user@[IPv6:2001:DB8::1]",
	"email@example.com",
	"firstname.lastname@example.com",
	"email@subdomain.example.com",
	"firstname+lastname@example.com",
	"email@123.123.123.123",
	"email@[123.123.123.123]",
	"\"email\"@example.com",
	"1234567890@example.com",
	"email@example-one.com",
	"_______@example.com",
	"email@example.name",
	"email@example.museum",
	"email@example.co.jp",
	"firstname-lastname@example.com",
	"much.”more\\ unusual”@example.com",
	"very.unusual.”@”.unusual.com@example.com",
	"very.”(),:;<>[]”.VERY.”very@\\ \"very”.unusual@strange.example.com",
	"#@%^%#$@#$@#.com",
	"@example.com",
	"Joe Smith <email@example.com>",
	"email@example@example.com",
	".email@example.com",
	"email.@example.com",
	"email..email@example.com",
	"あいうえお@example.com",
	"email@example.com (Joe Smith)",
	"email@example",
	"email@-example.com",
	"email@example.web",
	"email@111.222.333.44444",
	"email@example..com",
	"Abc..123@example.com",
	"”(),:;<>[\\]@example.com",
	"just”not”right@example.com",
	"this\\ is\"really\"not\\allowed@example.com",
	"email@example.com",
	"firstname.lastname@example.com",
	"email@subdomain.example.com",
	"firstname+lastname@example.com",
	"email@123.123.123.123",
	"email@[123.123.123.123]",
	"\"email\"@example.com",
	"1234567890@example.com",
	"email@example-one.com",
	"_______@example.com",
	"email@example.name",
	"email@example.museum",
	"email@example.co.jp",
	"firstname-lastname@example.com",
	"much.”moreunusual”@example.com",
	"very.unusual.””.unusual.com@example.com",
	"a!#$%&\"*+—/=?^_`{|}~1s.dv@12345-12345-12345-12345-12345-12345.ru",
	"あいうえお@example.com",
	"plainaddress",
	"#@%^%#$@#$@#.com",
	"@example.com",
	"Joe Smith <email@example.com>",
	"email.example.com",
	"email@example@example.com",
	".email@example.com",
	"email.@example.com",
	"email..email@example.com",
	"email@example.com (Joe Smith)",
	"email@example",
	"email@-example.com",
	"email@example.web",
	"email@111.222.333.44444",
	"email@example..com",
	"Abc..123@example.com",
	"”(),:;<>[]@example.com",
}

var Strings = []string{
	"undefined",
	"undef",
	"null",
	"NULL",
	"(null)",
	"nil",
	"NIL",
	"true",
	"false",
	"True",
	"False",
	"TRUE",
	"FALSE",
	"None",
	"hasOwnProperty",
	"\\",
	"\\\\",
	"0",
	"1",
	"1.00",
	"$1.00",
	"1/2",
	"1E2",
	"1E02",
	"1E+02",
	"-1",
	"-1.00",
	"-$1.00",
	"-1/2",
	"-1E2",
	"-1E02",
	"-1E+02",
	"1/0",
	"0/0",
	"-2147483648/-1",
	"-9223372036854775808/-1",
	"-0",
	"-0.0",
	"+0",
	"+0.0",
	"0.00",
	"0..0",
	".",
	"0.0.0",
	"0,00",
	"0,,0",
	",",
	"0,0,0",
	"0.0/0",
	"1.0/0.0",
	"0.0/0.0",
	"1,0/0,0",
	"0,0/0,0",
	"--1",
	"-",
	"-.",
	"-,",
	"999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999",
	"NaN",
	"Infinity",
	"-Infinity",
	"INF",
	"1#INF",
	"-1#IND",
	"1#QNAN",
	"1#SNAN",
	"1#IND",
	"0x0",
	"0xffffffff",
	"0xffffffffffffffff",
	"0xabad1dea",
	"123456789012345678901234567890123456789",
	"1,000.00",
	"1 000.00",
	"1'000.00",
	"1,000,000.00",
	"1 000 000.00",
	"1'000'000.00",
	"1.000,00",
	"1 000,00",
	"1'000,00",
	"1.000.000,00",
	"1 000 000,00",
	"1'000'000,00",
	"01000",
	"08",
	"09",
	"2.2250738585072011e-308",
	",./;'[]\\-=",
	"<>?:\"{}|_+",
	"!@#$%^&*()`~",
	"\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f",
	"￾",
	"Ω≈ç√∫˜µ≤≥÷",
	"åß∂ƒ©˙∆˚¬…æ",
	"œ∑´®†¥¨ˆøπ“‘",
	"¡™£¢∞§¶•ªº–≠",
	"¸˛Ç◊ı˜Â¯˘¿",
	"ÅÍÎÏ˝ÓÔÒÚÆ☃",
	"Œ„´‰ˇÁ¨ˆØ∏”’",
	"`⁄€‹›ﬁﬂ‡°·‚—±",
	"⅛⅜⅝⅞",
	"ЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя",
	"٠١٢٣٤٥٦٧٨٩",
	"⁰⁴⁵",
	"₀₁₂",
	"⁰⁴⁵₀₁₂",
	"ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็",
	"'",
	"\"",
	"''",
	"\"\"",
	"'\"'",
	"\"''''\"'\"",
	"\"'\"'\"''''\"",
	"<foo val=“bar” />",
	"<foo val=“bar” />",
	"<foo val=”bar“ />",
	"<foo val=`bar' />",
	"田中さんにあげて下さい",
	"パーティーへ行かないか",
	"和製漢語",
	"部落格",
	"사회과학원 어학연구소",
	"찦차를 타고 온 펲시맨과 쑛다리 똠방각하",
	"社會科學院語學研究所",
	"울란바토르",
	"𠜎𠜱𠝹𠱓𠱸𠲖𠳏",
	"表ポあA鷗ŒéＢ逍Üßªąñ丂㐀𠀀",
	"Ⱥ",
	"Ⱦ",
	"ヽ༼ຈل͜ຈ༽ﾉ ヽ༼ຈل͜ຈ༽ﾉ",
	"(｡◕ ∀ ◕｡)",
	"｀ｨ(´∀｀∩",
	"__ﾛ(,_,*)",
	"・(￣∀￣)・:*:",
	"ﾟ･✿ヾ╲(｡◕‿◕｡)╱✿･ﾟ",
	",。・:*:・゜’( ☻ ω ☻ )。・:*:・゜’",
	"(╯°□°）╯︵ ┻━┻)",
	"┬─┬ノ( º _ ºノ)",
	"( ͡° ͜ʖ ͡°)",
	"😍",
	"👩🏽",
	"👾 🙇 💁 🙅 🙆 🙋 🙎 🙍",
	"🐵 🙈 🙉 🙊",
	"❤️ 💔 💌 💕 💞 💓 💗 💖 💘 💝 💟 💜 💛 💚 💙",
	"✋🏿 💪🏿 👐🏿 🙌🏿 👏🏿 🙏🏿",
	"🚾 🆒 🆓 🆕 🆖 🆗 🆙 🏧",
	"0️⃣ 1️⃣ 2️⃣ 3️⃣ 4️⃣ 5️⃣ 6️⃣ 7️⃣ 8️⃣ 9️⃣ 🔟",
	"🇺🇸🇷🇺🇸 🇦🇫🇦🇲🇸",
	"🇺🇸🇷🇺🇸🇦🇫🇦🇲",
	"🇺🇸🇷🇺🇸🇦",
	"１２３",
	"١٢٣",
	"ثم نفس سقطت وبالتحديد،, جزيرتي باستخدام أن دنو. إذ هنا؟ الستار وتنصيب كان. أهّل ايطاليا، بريطانيا-فرنسا قد أخذ. سليمان، إتفاقية بين ما, يذكر الحدود أي بعد, معاملة بولندا، الإطلاق عل إيو.",
	"בְּרֵאשִׁית, בָּרָא אֱלֹהִים, אֵת הַשָּׁמַיִם, וְאֵת הָאָרֶץ",
	"הָיְתָהtestالصفحات التّحول",
	"﷽",
	"ﷺ",
	"مُنَاقَشَةُ سُبُلِ اِسْتِخْدَامِ اللُّغَةِ فِي النُّظُمِ الْقَائِمَةِ وَفِيم يَخُصَّ التَّطْبِيقَاتُ الْحاسُوبِيَّةُ، ",
	"‪‪test‪",
	"‫test‫",
	" test ",
	"test⁠test‫",
	"⁦test⁧",
	"Ṱ̺̺̕o͞ ̷i̲̬͇̪͙n̝̗͕v̟̜̘̦͟o̶̙̰̠kè͚̮̺̪̹̱̤ ̖t̝͕̳̣̻̪͞h̼͓̲̦̳̘̲e͇̣̰̦̬͎ ̢̼̻̱̘h͚͎͙̜̣̲ͅi̦̲̣̰̤v̻͍e̺̭̳̪̰-m̢iͅn̖̺̞̲̯̰d̵̼̟͙̩̼̘̳ ̞̥̱̳̭r̛̗̘e͙p͠r̼̞̻̭̗e̺̠̣͟s̘͇̳͍̝͉e͉̥̯̞̲͚̬͜ǹ̬͎͎̟̖͇̤t͍̬̤͓̼̭͘ͅi̪̱n͠g̴͉ ͏͉ͅc̬̟h͡a̫̻̯͘o̫̟̖͍̙̝͉s̗̦̲.̨̹͈̣",
	"̡͓̞ͅI̗̘̦͝n͇͇͙v̮̫ok̲̫̙͈i̖͙̭̹̠̞n̡̻̮̣̺g̲͈͙̭͙̬͎ ̰t͔̦h̞̲e̢̤ ͍̬̲͖f̴̘͕̣è͖ẹ̥̩l͖͔͚i͓͚̦͠n͖͍̗͓̳̮g͍ ̨o͚̪͡f̘̣̬ ̖̘͖̟͙̮c҉͔̫͖͓͇͖ͅh̵̤̣͚͔á̗̼͕ͅo̼̣̥s̱͈̺̖̦̻͢.̛̖̞̠̫̰",
	"̗̺͖̹̯͓Ṯ̤͍̥͇͈h̲́e͏͓̼̗̙̼̣͔ ͇̜̱̠͓͍ͅN͕͠e̗̱z̘̝̜̺͙p̤̺̹͍̯͚e̠̻̠͜r̨̤͍̺̖͔̖̖d̠̟̭̬̝͟i̦͖̩͓͔̤a̠̗̬͉̙n͚͜ ̻̞̰͚ͅh̵͉i̳̞v̢͇ḙ͎͟-҉̭̩̼͔m̤̭̫i͕͇̝̦n̗͙ḍ̟ ̯̲͕͞ǫ̟̯̰̲͙̻̝f ̪̰̰̗̖̭̘͘c̦͍̲̞͍̩̙ḥ͚a̮͎̟̙͜ơ̩̹͎s̤.̝̝ ҉Z̡̖̜͖̰̣͉̜a͖̰͙̬͡l̲̫̳͍̩g̡̟̼̱͚̞̬ͅo̗͜.̟",
	"̦H̬̤̗̤͝e͜ ̜̥̝̻͍̟́w̕h̖̯͓o̝͙̖͎̱̮ ҉̺̙̞̟͈W̷̼̭a̺̪͍į͈͕̭͙̯̜t̶̼̮s̘͙͖̕ ̠̫̠B̻͍͙͉̳ͅe̵h̵̬͇̫͙i̹͓̳̳̮͎̫̕n͟d̴̪̜̖ ̰͉̩͇͙̲͞ͅT͖̼͓̪͢h͏͓̮̻e̬̝̟ͅ ̤̹̝W͙̞̝͔͇͝ͅa͏͓͔̹̼̣l̴͔̰̤̟͔ḽ̫.͕",
	"Z̮̞̠͙͔ͅḀ̗̞͈̻̗Ḷ͙͎̯̹̞͓G̻O̭̗̮",
	"˙ɐnbᴉlɐ ɐuƃɐɯ ǝɹolop ʇǝ ǝɹoqɐl ʇn ʇunpᴉpᴉɔuᴉ ɹodɯǝʇ poɯsnᴉǝ op pǝs 'ʇᴉlǝ ƃuᴉɔsᴉdᴉpɐ ɹnʇǝʇɔǝsuoɔ 'ʇǝɯɐ ʇᴉs ɹolop ɯnsdᴉ ɯǝɹo˥",
	"00˙Ɩ$-",
	"Ｔｈｅ ｑｕｉｃｋ ｂｒｏｗｎ ｆｏｘ ｊｕｍｐｓ ｏｖｅｒ ｔｈｅ ｌａｚｙ ｄｏｇ",
	"𝐓𝐡𝐞 𝐪𝐮𝐢𝐜𝐤 𝐛𝐫𝐨𝐰𝐧 𝐟𝐨𝐱 𝐣𝐮𝐦𝐩𝐬 𝐨𝐯𝐞𝐫 𝐭𝐡𝐞 𝐥𝐚𝐳𝐲 𝐝𝐨𝐠",
	"𝕿𝖍𝖊 𝖖𝖚𝖎𝖈𝖐 𝖇𝖗𝖔𝖜𝖓 𝖋𝖔𝖝 𝖏𝖚𝖒𝖕𝖘 𝖔𝖛𝖊𝖗 𝖙𝖍𝖊 𝖑𝖆𝖟𝖞 𝖉𝖔𝖌",
	"𝑻𝒉𝒆 𝒒𝒖𝒊𝒄𝒌 𝒃𝒓𝒐𝒘𝒏 𝒇𝒐𝒙 𝒋𝒖𝒎𝒑𝒔 𝒐𝒗𝒆𝒓 𝒕𝒉𝒆 𝒍𝒂𝒛𝒚 𝒅𝒐𝒈",
	"𝓣𝓱𝓮 𝓺𝓾𝓲𝓬𝓴 𝓫𝓻𝓸𝔀𝓷 𝓯𝓸𝔁 𝓳𝓾𝓶𝓹𝓼 𝓸𝓿𝓮𝓻 𝓽𝓱𝓮 𝓵𝓪𝔃𝔂 𝓭𝓸𝓰",
	"𝕋𝕙𝕖 𝕢𝕦𝕚𝕔𝕜 𝕓𝕣𝕠𝕨𝕟 𝕗𝕠𝕩 𝕛𝕦𝕞𝕡𝕤 𝕠𝕧𝕖𝕣 𝕥𝕙𝕖 𝕝𝕒𝕫𝕪 𝕕𝕠𝕘",
	"𝚃𝚑𝚎 𝚚𝚞𝚒𝚌𝚔 𝚋𝚛𝚘𝚠𝚗 𝚏𝚘𝚡 𝚓𝚞𝚖𝚙𝚜 𝚘𝚟𝚎𝚛 𝚝𝚑𝚎 𝚕𝚊𝚣𝚢 𝚍𝚘𝚐",
	"⒯⒣⒠ ⒬⒰⒤⒞⒦ ⒝⒭⒪⒲⒩ ⒡⒪⒳ ⒥⒰⒨⒫⒮ ⒪⒱⒠⒭ ⒯⒣⒠ ⒧⒜⒵⒴ ⒟⒪⒢",
	"<script>alert(123)</script>",
	"&lt;script&gt;alert(&#39;123&#39;);&lt;/script&gt;",
	"<img src=x onerror=alert(123) />",
	"<svg><script>123<1>alert(123)</script>",
	"\"><script>alert(123)</script>",
	"'><script>alert(123)</script>",
	"><script>alert(123)</script>",
	"</script><script>alert(123)</script>",
	"< / script >< script >alert(123)< / script >",
	" onfocus=JaVaSCript:alert(123) autofocus",
	"\" onfocus=JaVaSCript:alert(123) autofocus",
	"' onfocus=JaVaSCript:alert(123) autofocus",
	"＜script＞alert(123)＜/script＞",
	"<sc<script>ript>alert(123)</sc</script>ript>",
	"--><script>alert(123)</script>",
	"\";alert(123);t=\"",
	"';alert(123);t='",
	"JavaSCript:alert(123)",
	";alert(123);",
	"src=JaVaSCript:prompt(132)",
	"\"><script>alert(123);</script x=\"",
	"'><script>alert(123);</script x='",
	"><script>alert(123);</script x=",
	"\" autofocus onkeyup=\"javascript:alert(123)",
	"' autofocus onkeyup='javascript:alert(123)",
	"<script\\x20type=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x3Etype=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x0Dtype=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x09type=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x0Ctype=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x2Ftype=\"text/javascript\">javascript:alert(1);</script>",
	"<script\\x0Atype=\"text/javascript\">javascript:alert(1);</script>",
	"'`\"><\\x3Cscript>javascript:alert(1)</script>",
	"'`\"><\\x00script>javascript:alert(1)</script>",
	"ABC<div style=\"x\\x3Aexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:expression\\x5C(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:expression\\x00(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:exp\\x00ression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:exp\\x5Cression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x0Aexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x09expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE3\\x80\\x80expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x84expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xC2\\xA0expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x80expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x8Aexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x0Dexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x0Cexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x87expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xEF\\xBB\\xBFexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x20expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x88expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x00expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x8Bexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x86expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x85expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x82expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\x0Bexpression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x81expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x83expression(javascript:alert(1)\">DEF",
	"ABC<div style=\"x:\\xE2\\x80\\x89expression(javascript:alert(1)\">DEF",
	"<a href=\"\\x0Bjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x0Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xC2\\xA0javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x05javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE1\\xA0\\x8Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x18javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x11javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x88javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x89javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x17javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x03javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x0Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x00javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x10javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x82javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x20javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x13javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x09javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x8Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x14javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x19javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\xAFjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x81javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Djavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x87javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x07javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE1\\x9A\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x83javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x04javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x01javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x08javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x84javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x86javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE3\\x80\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x12javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x0Djavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x0Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x0Cjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x15javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\xA8javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x16javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x02javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Bjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x06javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\xA9javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x80\\x85javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\xE2\\x81\\x9Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"\\x1Cjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"javascript\\x00:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"javascript\\x3A:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"javascript\\x09:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"javascript\\x0D:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"<a href=\"javascript\\x0A:javascript:alert(1)\" id=\"fuzzelement1\">test</a>",
	"`\"'><img src=xxx:x \\x0Aonerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x22onerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x0Bonerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x0Donerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x2Fonerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x09onerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x0Conerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x00onerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x27onerror=javascript:alert(1)>",
	"`\"'><img src=xxx:x \\x20onerror=javascript:alert(1)>",
	"\"`'><script>\\x3Bjavascript:alert(1)</script>",
	"\"`'><script>\\x0Djavascript:alert(1)</script>",
	"\"`'><script>\\xEF\\xBB\\xBFjavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x81javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x84javascript:alert(1)</script>",
	"\"`'><script>\\xE3\\x80\\x80javascript:alert(1)</script>",
	"\"`'><script>\\x09javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x89javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x85javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x88javascript:alert(1)</script>",
	"\"`'><script>\\x00javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\xA8javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x8Ajavascript:alert(1)</script>",
	"\"`'><script>\\xE1\\x9A\\x80javascript:alert(1)</script>",
	"\"`'><script>\\x0Cjavascript:alert(1)</script>",
	"\"`'><script>\\x2Bjavascript:alert(1)</script>",
	"\"`'><script>\\xF0\\x90\\x96\\x9Ajavascript:alert(1)</script>",
	"\"`'><script>-javascript:alert(1)</script>",
	"\"`'><script>\\x0Ajavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\xAFjavascript:alert(1)</script>",
	"\"`'><script>\\x7Ejavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x87javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x81\\x9Fjavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\xA9javascript:alert(1)</script>",
	"\"`'><script>\\xC2\\x85javascript:alert(1)</script>",
	"\"`'><script>\\xEF\\xBF\\xAEjavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x83javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x8Bjavascript:alert(1)</script>",
	"\"`'><script>\\xEF\\xBF\\xBEjavascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x80javascript:alert(1)</script>",
	"\"`'><script>\\x21javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x82javascript:alert(1)</script>",
	"\"`'><script>\\xE2\\x80\\x86javascript:alert(1)</script>",
	"\"`'><script>\\xE1\\xA0\\x8Ejavascript:alert(1)</script>",
	"\"`'><script>\\x0Bjavascript:alert(1)</script>",
	"\"`'><script>\\x20javascript:alert(1)</script>",
	"\"`'><script>\\xC2\\xA0javascript:alert(1)</script>",
	"<img \\x00src=x onerror=\"alert(1)\">",
	"<img \\x47src=x onerror=\"javascript:alert(1)\">",
	"<img \\x11src=x onerror=\"javascript:alert(1)\">",
	"<img \\x12src=x onerror=\"javascript:alert(1)\">",
	"<img\\x47src=x onerror=\"javascript:alert(1)\">",
	"<img\\x10src=x onerror=\"javascript:alert(1)\">",
	"<img\\x13src=x onerror=\"javascript:alert(1)\">",
	"<img\\x32src=x onerror=\"javascript:alert(1)\">",
	"<img\\x47src=x onerror=\"javascript:alert(1)\">",
	"<img\\x11src=x onerror=\"javascript:alert(1)\">",
	"<img \\x47src=x onerror=\"javascript:alert(1)\">",
	"<img \\x34src=x onerror=\"javascript:alert(1)\">",
	"<img \\x39src=x onerror=\"javascript:alert(1)\">",
	"<img \\x00src=x onerror=\"javascript:alert(1)\">",
	"<img src\\x09=x onerror=\"javascript:alert(1)\">",
	"<img src\\x10=x onerror=\"javascript:alert(1)\">",
	"<img src\\x13=x onerror=\"javascript:alert(1)\">",
	"<img src\\x32=x onerror=\"javascript:alert(1)\">",
	"<img src\\x12=x onerror=\"javascript:alert(1)\">",
	"<img src\\x11=x onerror=\"javascript:alert(1)\">",
	"<img src\\x00=x onerror=\"javascript:alert(1)\">",
	"<img src\\x47=x onerror=\"javascript:alert(1)\">",
	"<img src=x\\x09onerror=\"javascript:alert(1)\">",
	"<img src=x\\x10onerror=\"javascript:alert(1)\">",
	"<img src=x\\x11onerror=\"javascript:alert(1)\">",
	"<img src=x\\x12onerror=\"javascript:alert(1)\">",
	"<img src=x\\x13onerror=\"javascript:alert(1)\">",
	"<img[a][b][c]src[d]=x[e]onerror=[f]\"alert(1)\">",
	"<img src=x onerror=\\x09\"javascript:alert(1)\">",
	"<img src=x onerror=\\x10\"javascript:alert(1)\">",
	"<img src=x onerror=\\x11\"javascript:alert(1)\">",
	"<img src=x onerror=\\x12\"javascript:alert(1)\">",
	"<img src=x onerror=\\x32\"javascript:alert(1)\">",
	"<img src=x onerror=\\x00\"javascript:alert(1)\">",
	"<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(1)>XXX</a>",
	"<img src=\"x` `<script>javascript:alert(1)</script>\"` `>",
	"<img src onerror /\" '\"= alt=javascript:alert(1)//\">",
	"<title onpropertychange=javascript:alert(1)></title><title title=>",
	"<a href=http://foo.bar/#x=`y></a><img alt=\"`><img src=x:x onerror=javascript:alert(1)></a>\">",
	"<!--[if]><script>javascript:alert(1)</script -->",
	"<!--[if<img src=x onerror=javascript:alert(1)//]> -->",
	"<script src=\"/\\%(jscript)s\"></script>",
	"<script src=\"\\\\%(jscript)s\"></script>",
	"<IMG \"\"\"><SCRIPT>alert(\"XSS\")</SCRIPT>\">",
	"<IMG SRC=javascript:alert(String.fromCharCode(88,83,83))>",
	"<IMG SRC=# onmouseover=\"alert('xxs')\">",
	"<IMG SRC= onmouseover=\"alert('xxs')\">",
	"<IMG onmouseover=\"alert('xxs')\">",
	"<IMG SRC=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>",
	"<IMG SRC=&#0000106&#0000097&#0000118&#0000097&#0000115&#0000099&#0000114&#0000105&#0000112&#0000116&#0000058&#0000097&#0000108&#0000101&#0000114&#0000116&#0000040&#0000039&#0000088&#0000083&#0000083&#0000039&#0000041>",
	"<IMG SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29>",
	"<IMG SRC=\"jav   ascript:alert('XSS');\">",
	"<IMG SRC=\"jav&#x09;ascript:alert('XSS');\">",
	"<IMG SRC=\"jav&#x0A;ascript:alert('XSS');\">",
	"<IMG SRC=\"jav&#x0D;ascript:alert('XSS');\">",
	"perl -e 'print \"<IMG SRC=java\\0script:alert(\\\"XSS\\\")>\";' > out",
	"<IMG SRC=\" &#14;  javascript:alert('XSS');\">",
	"<SCRIPT/XSS SRC=\"http://ha.ckers.org/xss.js\"></SCRIPT>",
	"<BODY onload!#$%&()*~+-_.,:;?@[/|\\]^`=alert(\"XSS\")>",
	"<SCRIPT/SRC=\"http://ha.ckers.org/xss.js\"></SCRIPT>",
	"<<SCRIPT>alert(\"XSS\");//<</SCRIPT>",
	"<SCRIPT SRC=http://ha.ckers.org/xss.js?< B >",
	"<SCRIPT SRC=//ha.ckers.org/.j>",
	"<IMG SRC=\"javascript:alert('XSS')\"",
	"<iframe src=http://ha.ckers.org/scriptlet.html <",
	"\\\";alert('XSS');//",
	"<u oncopy=alert()> Copy me</u>",
	"<i onwheel=alert(1)> Scroll over me </i>",
	"<plaintext>",
	"http://a/%%30%30",
	"</textarea><script>alert(123)</script>",
	"1;DROP TABLE users",
	"1'; DROP TABLE users-- 1",
	"' OR 1=1 -- 1",
	"' OR '1'='1",
	" ",
	"%",
	"_",
	"-",
	"--",
	"--version",
	"--help",
	"$USER",
	"/dev/null; touch /tmp/blns.fail ; echo",
	"`touch /tmp/blns.fail`",
	"$(touch /tmp/blns.fail)",
	"@{[system \"touch /tmp/blns.fail\"]}",
	"eval(\"puts 'hello world'\")",
	"System(\"ls -al /\")",
	"`ls -al /`",
	"Kernel.exec(\"ls -al /\")",
	"Kernel.exit(1)",
	"%x('ls -al /')",
	"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM \"file:///etc/passwd\" >]><foo>&xxe;</foo>",
	"$HOME",
	"$ENV{'HOME'}",
	"%d",
	"%s%s%s%s%s",
	"{0}",
	"%*.*s",
	"%@",
	"%n",
	"File:///",
	"../../../../../../../../../../../etc/passwd%00",
	"../../../../../../../../../../../etc/hosts",
	"() { 0; }; touch /tmp/blns.shellshock1.fail;",
	"() { _; } >_[$($())] { touch /tmp/blns.shellshock2.fail; }",
	"<<< %s(un='%s') = %u",
	"+++ATH0",
	"CON",
	"PRN",
	"AUX",
	"CLOCK$",
	"NUL",
	"A:",
	"ZZ:",
	"COM1",
	"LPT1",
	"LPT2",
	"LPT3",
	"COM2",
	"COM3",
	"COM4",
	"DCC SEND STARTKEYLOGGER 0 0 0",
	"Scunthorpe General Hospital",
	"Penistone Community Church",
	"Lightwater Country Park",
	"Jimmy Clitheroe",
	"Horniman Museum",
	"shitake mushrooms",
	"RomansInSussex.co.uk",
	"http://www.cum.qc.ca/",
	"Craig Cockburn, Software Specialist",
	"Linda Callahan",
	"Dr. Herman I. Libshitz",
	"magna cum laude",
	"Super Bowl XXX",
	"medieval erection of parapets",
	"evaluate",
	"mocha",
	"expression",
	"Arsenal canal",
	"classic",
	"Tyson Gay",
	"Dick Van Dyke",
	"basement",
	"If you're reading this, you've been in a coma for almost 20 years now. We're trying a new technique. We don't know where this message will end up in your dream, but we hope it works. Please wake up, we miss you.",
	"Roses are \u001b[0;31mred\u001b[0m, violets are \u001b[0;34mblue. Hope you enjoy terminal hue",
	"But now...\u001b[20Cfor my greatest trick...\u001b[8m",
	"The quic\b\b\b\b\b\bk brown fo\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007x... [Beeeep]",
	"Powerلُلُصّبُلُلصّبُررً ॣ ॣh ॣ ॣ冗",
	"🏳0🌈️",
	"జ్ఞ‌ా",
	"dW5kZWZpbmVk",
	"dW5kZWY=",
	"bnVsbA==",
	"TlVMTA==",
	"KG51bGwp",
	"bmls",
	"TklM",
	"dHJ1ZQ==",
	"ZmFsc2U=",
	"VHJ1ZQ==",
	"RmFsc2U=",
	"VFJVRQ==",
	"RkFMU0U=",
	"Tm9uZQ==",
	"aGFzT3duUHJvcGVydHk=",
	"XA==",
	"MA==",
	"MQ==",
	"MS4wMA==",
	"JDEuMDA=",
	"MS8y",
	"MUUy",
	"MUUwMg==",
	"MUUrMDI=",
	"LTE=",
	"LTEuMDA=",
	"LSQxLjAw",
	"LTEvMg==",
	"LTFFMg==",
	"LTFFMDI=",
	"LTFFKzAy",
	"MS8w",
	"MC8w",
	"LTIxNDc0ODM2NDgvLTE=",
	"LTkyMjMzNzIwMzY4NTQ3NzU4MDgvLTE=",
	"LTA=",
	"LTAuMA==",
	"KzA=",
	"KzAuMA==",
	"MC4wMA==",
	"MC4uMA==",
	"Lg==",
	"MC4wLjA=",
	"MCwwMA==",
	"MCwsMA==",
	"LA==",
	"MCwwLDA=",
	"MC4wLzA=",
	"MS4wLzAuMA==",
	"MC4wLzAuMA==",
	"MSwwLzAsMA==",
	"MCwwLzAsMA==",
	"LS0x",
	"LQ==",
	"LS4=",
	"LSw=",
	"OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5",
	"OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5OTk5",
	"TmFO",
	"SW5maW5pdHk=",
	"LUluZmluaXR5",
	"SU5G",
	"MSNJTkY=",
	"LTEjSU5E",
	"MSNRTkFO",
	"MSNTTkFO",
	"MSNJTkQ=",
	"MHgw",
	"MHhmZmZmZmZmZg==",
	"MHhmZmZmZmZmZmZmZmZmZmZm",
	"MHhhYmFkMWRlYQ==",
	"MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5",
	"MSwwMDAuMDA=",
	"MSAwMDAuMDA=",
	"MScwMDAuMDA=",
	"MSwwMDAsMDAwLjAw",
	"MSAwMDAgMDAwLjAw",
	"MScwMDAnMDAwLjAw",
	"MS4wMDAsMDA=",
	"MSAwMDAsMDA=",
	"MScwMDAsMDA=",
	"MS4wMDAuMDAwLDAw",
	"MSAwMDAgMDAwLDAw",
	"MScwMDAnMDAwLDAw",
	"MDEwMDA=",
	"MDg=",
	"MDk=",
	"Mi4yMjUwNzM4NTg1MDcyMDExZS0zMDg=",
	"LC4vOydbXS09",
	"PD4/OiJ7fXxfKw==",
	"IUAjJCVeJiooKWB+",
	"AQIDBAUGBwgODxAREhMUFRYXGBkaGxwdHh9/",
	"woDCgcKCwoPChMKGwofCiMKJworCi8KMwo3CjsKPwpDCkcKSwpPClMKVwpbCl8KYwpnCmsKbwpzC",
	"ncKewp8=",
	"CwwgwoXCoOGagOKAgOKAgeKAguKAg+KAhOKAheKAhuKAh+KAiOKAieKAiuKAi+KAqOKAqeKAr+KB",
	"n+OAgA==",
	"wq3YgNiB2ILYg9iE2IXYnNud3I/hoI7igIvigIzigI3igI7igI/igKrigKvigKzigK3igK7igaDi",
	"gaHigaLigaPigaTigabigafigajiganigarigavigaziga3iga7iga/vu7/vv7nvv7rvv7vwkYK9",
	"8JuyoPCbsqHwm7Ki8Juyo/CdhbPwnYW08J2FtfCdhbbwnYW38J2FuPCdhbnwnYW686CAgfOggKDz",
	"oICh86CAovOggKPzoICk86CApfOggKbzoICn86CAqPOggKnzoICq86CAq/OggKzzoICt86CArvOg",
	"gK/zoICw86CAsfOggLLzoICz86CAtPOggLXzoIC286CAt/OggLjzoIC586CAuvOggLvzoIC886CA",
	"vfOggL7zoIC/86CBgPOggYHzoIGC86CBg/OggYTzoIGF86CBhvOggYfzoIGI86CBifOggYrzoIGL",
	"86CBjPOggY3zoIGO86CBj/OggZDzoIGR86CBkvOggZPzoIGU86CBlfOggZbzoIGX86CBmPOggZnz",
	"oIGa86CBm/OggZzzoIGd86CBnvOggZ/zoIGg86CBofOggaLzoIGj86CBpPOggaXzoIGm86CBp/Og",
	"gajzoIGp86CBqvOggavzoIGs86CBrfOgga7zoIGv86CBsPOggbHzoIGy86CBs/OggbTzoIG186CB",
	"tvOggbfzoIG486CBufOggbrzoIG786CBvPOggb3zoIG+86CBvw==",
	"77u/",
	"77++",
	"zqniiYjDp+KImuKIq8ucwrXiiaTiiaXDtw==",
	"w6XDn+KIgsaSwqnLmeKIhsuawqzigKbDpg==",
	"xZPiiJHCtMKu4oCgwqXCqMuGw7jPgOKAnOKAmA==",
	"wqHihKLCo8Ki4oiewqfCtuKAosKqwrrigJPiiaA=",
	"wrjLm8OH4peKxLHLnMOCwq/LmMK/",
	"w4XDjcOOw4/LncOTw5Tvo7/DksOaw4bimIM=",
	"xZLigJ7CtOKAsMuHw4HCqMuGw5jiiI/igJ3igJk=",
	"YOKBhOKCrOKAueKAuu+sge+sguKAocKwwrfigJrigJTCsQ==",
	"4oWb4oWc4oWd4oWe",
	"0IHQgtCD0ITQhdCG0IfQiNCJ0IrQi9CM0I3QjtCP0JDQkdCS0JPQlNCV0JbQl9CY0JnQmtCb0JzQ",
	"ndCe0J/QoNCh0KLQo9Ck0KXQptCn0KjQqdCq0KvQrNCt0K7Qr9Cw0LHQstCz0LTQtdC20LfQuNC5",
	"0LrQu9C80L3QvtC/0YDRgdGC0YPRhNGF0YbRh9GI0YnRitGL0YzRjdGO0Y8=",
	"2aDZodmi2aPZpNml2abZp9mo2ak=",
	"4oGw4oG04oG1",
	"4oKA4oKB4oKC",
	"4oGw4oG04oG14oKA4oKB4oKC",
	"4LiU4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH4LmH4LmH4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH",
	"4LmH4LmH4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH4LmH4LmH4LmJ4LmJ4LmJ4LmJ",
	"4LmJ4LmH4LmH4LmH4LmH4LmH4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH4LmH4LmH",
	"4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH4LmH4LmH4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmJ4LmH",
	"4LmH4LmH4LmH4LmH4LmJ4LmJ4LmJ4LmJ4LmJ4LmH4LmH4LmH4LmHIOC4lOC5ieC5ieC5ieC5ieC5",
	"ieC5h+C5h+C5h+C5h+C5h+C5ieC5ieC5ieC5ieC5ieC5h+C5h+C5h+C5h+C5h+C5ieC5ieC5ieC5",
	"ieC5ieC5ieC5ieC5ieC5h+C5h+C5h+C5h+C5h+C5ieC5ieC5ieC5ieC5ieC5h+C5h+C5h+C5h+C5",
	"h+C5ieC5ieC5ieC5ieC5ieC5ieC5ieC5ieC5h+C5h+C5h+C5h+C5h+C5ieC5ieC5ieC5ieC5ieC5",
	"h+C5h+C5h+C5h+C5h+C5ieC5ieC5ieC5ieC5ieC5ieC5ieC5ieC5h+C5h+C5h+C5h+C5h+C5ieC5",
	"ieC5ieC5ieC5ieC5h+C5h+C5h+C5hyDguJTguYnguYnguYnguYnguYnguYfguYfguYfguYfguYfg",
	"uYnguYnguYnguYnguYnguYfguYfguYfguYfguYfguYnguYnguYnguYnguYnguYnguYnguYnguYfg",
	"uYfguYfguYfguYfguYnguYnguYnguYnguYnguYfguYfguYfguYfguYfguYnguYnguYnguYnguYng",
	"uYnguYnguYnguYfguYfguYfguYfguYfguYnguYnguYnguYnguYnguYfguYfguYfguYfguYfguYng",
	"uYnguYnguYnguYnguYnguYnguYnguYfguYfguYfguYfguYfguYnguYnguYnguYnguYnguYfguYfg",
	"uYfguYc=",
	"Jw==",
	"Ig==",
	"Jyc=",
	"IiI=",
	"JyIn",
	"IicnJyciJyI=",
	"IiciJyInJycnIg==",
	"PGZvbyB2YWw94oCcYmFy4oCdIC8+",
	"PGZvbyB2YWw94oCcYmFy4oCdIC8+",
	"PGZvbyB2YWw94oCdYmFy4oCcIC8+",
	"PGZvbyB2YWw9YGJhcicgLz4=",
	"55Sw5Lit44GV44KT44Gr44GC44GS44Gm5LiL44GV44GE",
	"44OR44O844OG44Kj44O844G46KGM44GL44Gq44GE44GL",
	"5ZKM6KO95ryi6Kqe",
	"6YOo6JC95qC8",
	"7IKs7ZqM6rO87ZWZ7JuQIOyWtO2VmeyXsOq1rOyGjA==",
	"7LCm7LCo66W8IO2DgOqzoCDsmKgg7Y6y7Iuc66eo6rO8IOyRm+uLpOumrCDrmKDrsKnqsIHtlZg=",
	"56S+5pyD56eR5a246Zmi6Kqe5a2456CU56m25omA",
	"7Jq4656A67CU7Yag66W0",
	"8KCcjvCgnLHwoJ258KCxk/CgsbjwoLKW8KCzjw==",
	"6KGo44Od44GCQem3l8WSw6nvvKLpgI3DnMOfwqrEhcOx5LiC45CA8KCAgA==",
	"44O94Ly84LqI2YTNnOC6iOC8ve++iSDjg73gvLzguojZhM2c4LqI4Ly9776J",
	"KO+9oeKXlSDiiIAg4peV772hKQ==",
	"772A772oKMK04oiA772A4oip",
	"X1/vvpsoLF8sKik=",
	"44O7KO+/o+KIgO+/oynjg7s6Kjo=",
	"776f772l4py/44O+4pWyKO+9oeKXleKAv+KXle+9oSnilbHinL/vvaXvvp8=",
	"LOOAguODuzoqOuODu+OCnOKAmSgg4pi7IM+JIOKYuyAp44CC44O7Oio644O744Kc4oCZ",
	"KOKVr8Kw4pahwrDvvInila/vuLUg4pS74pSB4pS7KQ==",
	"KO++ieCypeebiuCype+8ie++ie+7vyDilLvilIHilLs=",
	"4pSs4pSA4pSs44OOKCDCuiBfIMK644OOKQ==",
	"KCDNocKwIM2cypYgzaHCsCk=",
	"8J+YjQ==",
	"8J+RqfCfj70=",
	"8J+RviDwn5mHIPCfkoEg8J+ZhSDwn5mGIPCfmYsg8J+ZjiDwn5mN",
	"8J+QtSDwn5mIIPCfmYkg8J+Zig==",
	"4p2k77iPIPCfkpQg8J+SjCDwn5KVIPCfkp4g8J+SkyDwn5KXIPCfkpYg8J+SmCDwn5KdIPCfkp8g",
	"8J+SnCDwn5KbIPCfkpog8J+SmQ==",
	"4pyL8J+PvyDwn5Kq8J+PvyDwn5GQ8J+PvyDwn5mM8J+PvyDwn5GP8J+PvyDwn5mP8J+Pvw==",
	"8J+aviDwn4aSIPCfhpMg8J+GlSDwn4aWIPCfhpcg8J+GmSDwn4+n",
	"MO+4j+KDoyAx77iP4oOjIDLvuI/ig6MgM++4j+KDoyA077iP4oOjIDXvuI/ig6MgNu+4j+KDoyA3",
	"77iP4oOjIDjvuI/ig6MgOe+4j+KDoyDwn5Sf",
	"8J+HuvCfh7jwn4e38J+HuvCfh7gg8J+HpvCfh6vwn4em8J+HsvCfh7g=",
	"8J+HuvCfh7jwn4e38J+HuvCfh7jwn4em8J+Hq/Cfh6bwn4ey",
	"8J+HuvCfh7jwn4e38J+HuvCfh7jwn4em",
	"77yR77yS77yT",
	"2aHZotmj",
	"2KvZhSDZhtmB2LMg2LPZgti32Kog2YjYqNin2YTYqtit2K/Zitiv2IwsINis2LLZitix2KrZiiDY",
	"qNin2LPYqtiu2K/Yp9mFINij2YYg2K/ZhtmILiDYpdiwINmH2YbYp9ifINin2YTYs9iq2KfYsSDZ",
	"iNiq2YbYtdmK2Kgg2YPYp9mGLiDYo9mH2ZHZhCDYp9mK2LfYp9mE2YrYp9iMINio2LHZiti32KfZ",
	"htmK2Kct2YHYsdmG2LPYpyDZgtivINij2K7YsC4g2LPZhNmK2YXYp9mG2Iwg2KXYqtmB2KfZgtmK",
	"2Kkg2KjZitmGINmF2KcsINmK2LDZg9ixINin2YTYrdiv2YjYryDYo9mKINio2LnYrywg2YXYudin",
	"2YXZhNipINio2YjZhNmG2K/Yp9iMINin2YTYpdi32YTYp9mCINi52YQg2KXZitmILg==",
	"15HWsNa816jWtdeQ16nWtNeB15nXqiwg15HWuNa816jWuNeQINeQ1rHXnNa515TWtNeZ150sINeQ",
	"1rXXqiDXlNa316nWuNa814HXnta315nWtNedLCDXldaw15DWtdeqINeU1rjXkNa416jWttel",
	"15TWuNeZ1rDXqta415R0ZXN02KfZhNi12YHYrdin2Kog2KfZhNiq2ZHYrdmI2YQ=",
	"77e9",
	"77e6",
	"2YXZj9mG2Y7Yp9mC2Y7YtNmO2KnZjyDYs9mP2KjZj9mE2ZAg2KfZkNiz2ZLYqtmQ2K7Zktiv2Y7Y",
	"p9mF2ZAg2KfZhNmE2ZHZj9i62Y7YqdmQINmB2ZDZiiDYp9mE2YbZkdmP2LjZj9mF2ZAg2KfZhNmS",
	"2YLZjtin2KbZkNmF2Y7YqdmQINmI2Y7ZgdmQ2YrZhSDZitmO2K7Zj9i12ZHZjiDYp9mE2KrZkdmO",
	"2LfZktio2ZDZitmC2Y7Yp9iq2Y8g2KfZhNmS2K3Yp9iz2Y/ZiNio2ZDZitmR2Y7YqdmP2Iw=",
	"4oCq4oCqdGVzdOKAqg==",
	"4oCrdGVzdOKAqw==",
	"4oCpdGVzdOKAqQ==",
	"dGVzdOKBoHRlc3TigKs=",
	"4oGmdGVzdOKBpw==",
	"4bmwzLrMusyVb82eIMy3acyyzKzNh8yqzZluzJ3Ml82VdsyfzJzMmMymzZ9vzLbMmcywzKBrw6jN",
	"msyuzLrMqsy5zLHMpCDMlnTMnc2VzLPMo8y7zKrNnmjMvM2TzLLMpsyzzJjMsmXNh8yjzLDMpsys",
	"zY4gzKLMvMy7zLHMmGjNms2OzZnMnMyjzLLNhWnMpsyyzKPMsMykdsy7zY1lzLrMrcyzzKrMsC1t",
	"zKJpzYVuzJbMusyezLLMr8ywZMy1zLzMn82ZzKnMvMyYzLMgzJ7MpcyxzLPMrXLMm8yXzJhlzZlw",
	"zaByzLzMnsy7zK3Ml2XMusygzKPNn3PMmM2HzLPNjcydzYllzYnMpcyvzJ7Mss2azKzNnMe5zKzN",
	"js2OzJ/Mls2HzKR0zY3MrMykzZPMvMytzZjNhWnMqsyxbs2gZ8y0zYkgzY/Nic2FY8yszJ9ozaFh",
	"zKvMu8yvzZhvzKvMn8yWzY3MmcydzYlzzJfMpsyyLsyozLnNiMyj",
	"zKHNk8yezYVJzJfMmMymzZ1uzYfNh82ZdsyuzKtva8yyzKvMmc2IacyWzZnMrcy5zKDMnm7Mocy7",
	"zK7Mo8y6Z8yyzYjNmcytzZnMrM2OIMywdM2UzKZozJ7MsmXMosykIM2NzKzMss2WZsy0zJjNlcyj",
	"w6jNluG6ucylzKlszZbNlM2aac2TzZrMps2gbs2WzY3Ml82TzLPMrmfNjSDMqG/NmsyqzaFmzJjM",
	"o8ysIMyWzJjNlsyfzZnMrmPSic2UzKvNls2TzYfNls2FaMy1zKTMo82azZTDocyXzLzNlc2Fb8y8",
	"zKPMpXPMsc2IzLrMlsymzLvNoi7Mm8yWzJ7MoMyrzLA=",
	"zJfMus2WzLnMr82T4bmuzKTNjcylzYfNiGjMssyBZc2PzZPMvMyXzJnMvMyjzZQgzYfMnMyxzKDN",
	"k82NzYVOzZXNoGXMl8yxesyYzJ3MnMy6zZlwzKTMusy5zY3Mr82aZcygzLvMoM2ccsyozKTNjcy6",
	"zJbNlMyWzJZkzKDMn8ytzKzMnc2facymzZbMqc2TzZTMpGHMoMyXzKzNicyZbs2azZwgzLvMnsyw",
	"zZrNhWjMtc2JacyzzJ52zKLNh+G4mc2OzZ8t0onMrcypzLzNlG3MpMytzKtpzZXNh8ydzKZuzJfN",
	"meG4jcyfIMyvzLLNlc2ex6vMn8yvzLDMss2ZzLvMnWYgzKrMsMywzJfMlsytzJjNmGPMps2NzLLM",
	"ns2NzKnMmeG4pc2aYcyuzY7Mn8yZzZzGocypzLnNjnPMpC7MncydINKJWsyhzJbMnM2WzLDMo82J",
	"zJxhzZbMsM2ZzKzNoWzMssyrzLPNjcypZ8yhzJ/MvMyxzZrMnsyszYVvzJfNnC7Mnw==",
	"zKZIzKzMpMyXzKTNnWXNnCDMnMylzJ3Mu82NzJ/MgXfMlWjMlsyvzZNvzJ3NmcyWzY7MscyuINKJ",
	"zLrMmcyezJ/NiFfMt8y8zK1hzLrMqs2NxK/NiM2VzK3NmcyvzJx0zLbMvMyuc8yYzZnNlsyVIMyg",
	"zKvMoELMu82NzZnNicyzzYVlzLVozLXMrM2HzKvNmWnMuc2TzLPMs8yuzY7Mq8yVbs2fZMy0zKrM",
	"nMyWIMywzYnMqc2HzZnMss2ezYVUzZbMvM2TzKrNomjNj82TzK7Mu2XMrMydzJ/NhSDMpMy5zJ1X",
	"zZnMnsydzZTNh82dzYVhzY/Nk82UzLnMvMyjbMy0zZTMsMykzJ/NlOG4vcyrLs2V",
	"WsyuzJ7MoM2ZzZTNheG4gMyXzJ7NiMy7zJfhuLbNmc2OzK/MucyezZNHzLtPzK3Ml8yu",
	"y5nJkG5i4bSJbMmQIMmQdcaDyZDJryDHncm5b2xvcCDKh8edIMedyblvccmQbCDKh24gyod1bnDh",
	"tIlw4bSJyZR14bSJIMm5b2TJr8edyocgcG/Jr3Nu4bSJx50gb3AgcMedcyAnyofhtIlsx50gxoN1",
	"4bSJyZRz4bSJZOG0iXDJkCDJuW7Kh8edyofJlMedc3VvyZQgJ8qHx53Jr8mQIMqH4bSJcyDJuW9s",
	"b3Agya9uc2ThtIkgya/Hncm5b8ul",
	"MDDLmcaWJC0=",
	"77y0772I772FIO+9ke+9le+9ie+9g++9iyDvvYLvvZLvvY/vvZfvvY4g772G772P772YIO+9iu+9",
	"le+9je+9kO+9kyDvvY/vvZbvvYXvvZIg772U772I772FIO+9jO+9ge+9mu+9mSDvvYTvvY/vvYc=",
	"8J2Qk/CdkKHwnZCeIPCdkKrwnZCu8J2QovCdkJzwnZCkIPCdkJvwnZCr8J2QqPCdkLDwnZCnIPCd",
	"kJ/wnZCo8J2QsSDwnZCj8J2QrvCdkKbwnZCp8J2QrCDwnZCo8J2Qr/CdkJ7wnZCrIPCdkK3wnZCh",
	"8J2QniDwnZCl8J2QmvCdkLPwnZCyIPCdkJ3wnZCo8J2QoA==",
	"8J2Vv/Cdlo3wnZaKIPCdlpbwnZaa8J2WjvCdlojwnZaQIPCdlofwnZaX8J2WlPCdlpzwnZaTIPCd",
	"lovwnZaU8J2WnSDwnZaP8J2WmvCdlpLwnZaV8J2WmCDwnZaU8J2Wm/CdlorwnZaXIPCdlpnwnZaN",
	"8J2WiiDwnZaR8J2WhvCdlp/wnZaeIPCdlonwnZaU8J2WjA==",
	"8J2Ru/CdkonwnZKGIPCdkpLwnZKW8J2SivCdkoTwnZKMIPCdkoPwnZKT8J2SkPCdkpjwnZKPIPCd",
	"kofwnZKQ8J2SmSDwnZKL8J2SlvCdko7wnZKR8J2SlCDwnZKQ8J2Sl/CdkobwnZKTIPCdkpXwnZKJ",
	"8J2ShiDwnZKN8J2SgvCdkpvwnZKaIPCdkoXwnZKQ8J2SiA==",
	"8J2To/Cdk7HwnZOuIPCdk7rwnZO+8J2TsvCdk6zwnZO0IPCdk6vwnZO78J2TuPCdlIDwnZO3IPCd",
	"k6/wnZO48J2UgSDwnZOz8J2TvvCdk7bwnZO58J2TvCDwnZO48J2Tv/Cdk67wnZO7IPCdk73wnZOx",
	"8J2TriDwnZO18J2TqvCdlIPwnZSCIPCdk63wnZO48J2TsA==",
	"8J2Vi/CdlZnwnZWWIPCdlaLwnZWm8J2VmvCdlZTwnZWcIPCdlZPwnZWj8J2VoPCdlajwnZWfIPCd",
	"lZfwnZWg8J2VqSDwnZWb8J2VpvCdlZ7wnZWh8J2VpCDwnZWg8J2Vp/CdlZbwnZWjIPCdlaXwnZWZ",
	"8J2VliDwnZWd8J2VkvCdlavwnZWqIPCdlZXwnZWg8J2VmA==",
	"8J2ag/CdmpHwnZqOIPCdmprwnZqe8J2akvCdmozwnZqUIPCdmovwnZqb8J2amPCdmqDwnZqXIPCd",
	"mo/wnZqY8J2aoSDwnZqT8J2anvCdmpbwnZqZ8J2anCDwnZqY8J2an/Cdmo7wnZqbIPCdmp3wnZqR",
	"8J2ajiDwnZqV8J2aivCdmqPwnZqiIPCdmo3wnZqY8J2akA==",
	"4pKv4pKj4pKgIOKSrOKSsOKSpOKSnuKSpiDikp3ikq3ikqrikrLikqkg4pKh4pKq4pKzIOKSpeKS",
	"sOKSqOKSq+KSriDikqrikrHikqDikq0g4pKv4pKj4pKgIOKSp+KSnOKSteKStCDikp/ikqrikqI=",
	"PHNjcmlwdD5hbGVydCgxMjMpPC9zY3JpcHQ+",
	"Jmx0O3NjcmlwdCZndDthbGVydCgmIzM5OzEyMyYjMzk7KTsmbHQ7L3NjcmlwdCZndDs=",
	"PGltZyBzcmM9eCBvbmVycm9yPWFsZXJ0KDEyMykgLz4=",
	"PHN2Zz48c2NyaXB0PjEyMzwxPmFsZXJ0KDEyMyk8L3NjcmlwdD4=",
	"Ij48c2NyaXB0PmFsZXJ0KDEyMyk8L3NjcmlwdD4=",
	"Jz48c2NyaXB0PmFsZXJ0KDEyMyk8L3NjcmlwdD4=",
	"PjxzY3JpcHQ+YWxlcnQoMTIzKTwvc2NyaXB0Pg==",
	"PC9zY3JpcHQ+PHNjcmlwdD5hbGVydCgxMjMpPC9zY3JpcHQ+",
	"PCAvIHNjcmlwdCA+PCBzY3JpcHQgPmFsZXJ0KDEyMyk8IC8gc2NyaXB0ID4=",
	"b25mb2N1cz1KYVZhU0NyaXB0OmFsZXJ0KDEyMykgYXV0b2ZvY3Vz",
	"IiBvbmZvY3VzPUphVmFTQ3JpcHQ6YWxlcnQoMTIzKSBhdXRvZm9jdXM=",
	"JyBvbmZvY3VzPUphVmFTQ3JpcHQ6YWxlcnQoMTIzKSBhdXRvZm9jdXM=",
	"77ycc2NyaXB077yeYWxlcnQoMTIzKe+8nC9zY3JpcHTvvJ4=",
	"PHNjPHNjcmlwdD5yaXB0PmFsZXJ0KDEyMyk8L3NjPC9zY3JpcHQ+cmlwdD4=",
	"LS0+PHNjcmlwdD5hbGVydCgxMjMpPC9zY3JpcHQ+",
	"IjthbGVydCgxMjMpO3Q9Ig==",
	"JzthbGVydCgxMjMpO3Q9Jw==",
	"SmF2YVNDcmlwdDphbGVydCgxMjMp",
	"O2FsZXJ0KDEyMyk7",
	"c3JjPUphVmFTQ3JpcHQ6cHJvbXB0KDEzMik=",
	"Ij48c2NyaXB0PmFsZXJ0KDEyMyk7PC9zY3JpcHQgeD0i",
	"Jz48c2NyaXB0PmFsZXJ0KDEyMyk7PC9zY3JpcHQgeD0n",
	"PjxzY3JpcHQ+YWxlcnQoMTIzKTs8L3NjcmlwdCB4PQ==",
	"IiBhdXRvZm9jdXMgb25rZXl1cD0iamF2YXNjcmlwdDphbGVydCgxMjMp",
	"JyBhdXRvZm9jdXMgb25rZXl1cD0namF2YXNjcmlwdDphbGVydCgxMjMp",
	"PHNjcmlwdHgyMHR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgzRXR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgwRHR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgwOXR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgwQ3R5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgyRnR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"PHNjcmlwdHgwQXR5cGU9InRleHQvamF2YXNjcmlwdCI+amF2YXNjcmlwdDphbGVydCgxKTs8L3Nj",
	"cmlwdD4=",
	"J2AiPjx4M0NzY3JpcHQ+amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"J2AiPjx4MDBzY3JpcHQ+amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"QUJDPGRpdiBzdHlsZT0ieHgzQWV4cHJlc3Npb24oamF2YXNjcmlwdDphbGVydCgxKSI+REVG",
	"QUJDPGRpdiBzdHlsZT0ieDpleHByZXNzaW9ueDVDKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDpleHByZXNzaW9ueDAwKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDpleHB4MDByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDpleHB4NUNyZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MEFleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MDlleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTN4ODB4ODBleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODRleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4QzJ4QTBleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRF",
	"Rg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODBleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4OEFleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MERleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MENleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODdleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RUZ4QkJ4QkZleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MjBleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODhleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MDBleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4OEJleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODZleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODVleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODJleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4MEJleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSkiPkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODFleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODNleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"QUJDPGRpdiBzdHlsZT0ieDp4RTJ4ODB4ODlleHByZXNzaW9uKGphdmFzY3JpcHQ6YWxlcnQoMSki",
	"PkRFRg==",
	"PGEgaHJlZj0ieDBCamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDBGamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEMyeEEwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVs",
	"ZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA1amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUxeEEweDhFamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE4amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDExamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg4amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg5amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDgwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE3amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDAzamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDBFamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFBamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDAwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDEwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDgyamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDIwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDEzamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA5amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDhBamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE0amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE5amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweEFGamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFGamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDgxamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFEamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg3amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA3amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUxeDlBeDgwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDgzamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA0amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDAxamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA4amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg0amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg2amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUzeDgweDgwamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDEyamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDBEamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDBBamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDBDamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE1amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweEE4amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDE2amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDAyamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFCamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDA2amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweEE5amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgweDg1amF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFFamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieEUyeDgxeDlGamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6",
	"emVsZW1lbnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0ieDFDamF2YXNjcmlwdDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0iamF2YXNjcmlwdHgwMDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0iamF2YXNjcmlwdHgzQTpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0iamF2YXNjcmlwdHgwOTpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0iamF2YXNjcmlwdHgwRDpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"PGEgaHJlZj0iamF2YXNjcmlwdHgwQTpqYXZhc2NyaXB0OmFsZXJ0KDEpIiBpZD0iZnV6emVsZW1l",
	"bnQxIj50ZXN0PC9hPg==",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwQW9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgyMm9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwQm9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwRG9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgyRm9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwOW9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwQ29uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgwMG9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgyN29uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"YCInPjxpbWcgc3JjPXh4eDp4IHgyMG9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT4=",
	"ImAnPjxzY3JpcHQ+eDNCamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDBEamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEVGeEJCeEJGamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDgxamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg0amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUzeDgweDgwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDA5amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg5amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg1amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg4amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDAwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweEE4amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDhBamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUxeDlBeDgwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDBDamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDJCamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEYweDkweDk2eDlBamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+LWphdmFzY3JpcHQ6YWxlcnQoMSk8L3NjcmlwdD4=",
	"ImAnPjxzY3JpcHQ+eDBBamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweEFGamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDdFamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg3amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgxeDlGamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweEE5amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEMyeDg1amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEVGeEJGeEFFamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDgzamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDhCamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEVGeEJGeEJFamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDgwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDIxamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDgyamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUyeDgweDg2amF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEUxeEEweDhFamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDBCamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eDIwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"ImAnPjxzY3JpcHQ+eEMyeEEwamF2YXNjcmlwdDphbGVydCgxKTwvc2NyaXB0Pg==",
	"PGltZyB4MDBzcmM9eCBvbmVycm9yPSJhbGVydCgxKSI+",
	"PGltZyB4NDdzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyB4MTFzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyB4MTJzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZ3g0N3NyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ3gxMHNyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ3gxM3NyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ3gzMnNyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ3g0N3NyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ3gxMXNyYz14IG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZyB4NDdzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyB4MzRzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyB4MzlzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyB4MDBzcmM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MDk9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MTA9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MTM9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MzI9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MTI9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MTE9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4MDA9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmN4NDc9eCBvbmVycm9yPSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eHgwOW9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZyBzcmM9eHgxMG9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZyBzcmM9eHgxMW9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZyBzcmM9eHgxMm9uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZyBzcmM9eHgxM29uZXJyb3I9ImphdmFzY3JpcHQ6YWxlcnQoMSkiPg==",
	"PGltZ1thXVtiXVtjXXNyY1tkXT14W2Vdb25lcnJvcj1bZl0iYWxlcnQoMSkiPg==",
	"PGltZyBzcmM9eCBvbmVycm9yPXgwOSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eCBvbmVycm9yPXgxMCJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eCBvbmVycm9yPXgxMSJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eCBvbmVycm9yPXgxMiJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eCBvbmVycm9yPXgzMiJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGltZyBzcmM9eCBvbmVycm9yPXgwMCJqYXZhc2NyaXB0OmFsZXJ0KDEpIj4=",
	"PGEgaHJlZj1qYXZhJiMxJiMyJiMzJiM0JiM1JiM2JiM3JiM4JiMxMSYjMTJzY3JpcHQ6amF2YXNj",
	"cmlwdDphbGVydCgxKT5YWFg8L2E+",
	"PGltZyBzcmM9InhgIGA8c2NyaXB0PmphdmFzY3JpcHQ6YWxlcnQoMSk8L3NjcmlwdD4iYCBgPg==",
	"PGltZyBzcmMgb25lcnJvciAvIiAnIj0gYWx0PWphdmFzY3JpcHQ6YWxlcnQoMSkvLyI+",
	"PHRpdGxlIG9ucHJvcGVydHljaGFuZ2U9amF2YXNjcmlwdDphbGVydCgxKT48L3RpdGxlPjx0aXRs",
	"ZSB0aXRsZT0+",
	"PGEgaHJlZj1odHRwOi8vZm9vLmJhci8jeD1geT48L2E+PGltZyBhbHQ9ImA+PGltZyBzcmM9eDp4",
	"IG9uZXJyb3I9amF2YXNjcmlwdDphbGVydCgxKT48L2E+Ij4=",
	"PCEtLVtpZl0+PHNjcmlwdD5qYXZhc2NyaXB0OmFsZXJ0KDEpPC9zY3JpcHQgLS0+",
	"PCEtLVtpZjxpbWcgc3JjPXggb25lcnJvcj1qYXZhc2NyaXB0OmFsZXJ0KDEpLy9dPiAtLT4=",
	"PHNjcmlwdCBzcmM9Ii8lKGpzY3JpcHQpcyI+PC9zY3JpcHQ+",
	"PHNjcmlwdCBzcmM9IlwlKGpzY3JpcHQpcyI+PC9zY3JpcHQ+",
	"PElNRyAiIiI+PFNDUklQVD5hbGVydCgiWFNTIik8L1NDUklQVD4iPg==",
	"PElNRyBTUkM9amF2YXNjcmlwdDphbGVydChTdHJpbmcuZnJvbUNoYXJDb2RlKDg4LDgzLDgzKSk+",
	"PElNRyBTUkM9IyBvbm1vdXNlb3Zlcj0iYWxlcnQoJ3h4cycpIj4=",
	"PElNRyBTUkM9IG9ubW91c2VvdmVyPSJhbGVydCgneHhzJykiPg==",
	"PElNRyBvbm1vdXNlb3Zlcj0iYWxlcnQoJ3h4cycpIj4=",
	"PElNRyBTUkM9JiMxMDY7JiM5NzsmIzExODsmIzk3OyYjMTE1OyYjOTk7JiMxMTQ7JiMxMDU7JiMx",
	"MTI7JiMxMTY7JiM1ODsmIzk3OyYjMTA4OyYjMTAxOyYjMTE0OyYjMTE2OyYjNDA7JiMzOTsmIzg4",
	"OyYjODM7JiM4MzsmIzM5OyYjNDE7Pg==",
	"PElNRyBTUkM9JiMwMDAwMTA2JiMwMDAwMDk3JiMwMDAwMTE4JiMwMDAwMDk3JiMwMDAwMTE1JiMw",
	"MDAwMDk5JiMwMDAwMTE0JiMwMDAwMTA1JiMwMDAwMTEyJiMwMDAwMTE2JiMwMDAwMDU4JiMwMDAw",
	"MDk3JiMwMDAwMTA4JiMwMDAwMTAxJiMwMDAwMTE0JiMwMDAwMTE2JiMwMDAwMDQwJiMwMDAwMDM5",
	"JiMwMDAwMDg4JiMwMDAwMDgzJiMwMDAwMDgzJiMwMDAwMDM5JiMwMDAwMDQxPg==",
	"PElNRyBTUkM9JiN4NkEmI3g2MSYjeDc2JiN4NjEmI3g3MyYjeDYzJiN4NzImI3g2OSYjeDcwJiN4",
	"NzQmI3gzQSYjeDYxJiN4NkMmI3g2NSYjeDcyJiN4NzQmI3gyOCYjeDI3JiN4NTgmI3g1MyYjeDUz",
	"JiN4MjcmI3gyOT4=",
	"PElNRyBTUkM9ImphdiBhc2NyaXB0OmFsZXJ0KCdYU1MnKTsiPg==",
	"PElNRyBTUkM9ImphdiYjeDA5O2FzY3JpcHQ6YWxlcnQoJ1hTUycpOyI+",
	"PElNRyBTUkM9ImphdiYjeDBBO2FzY3JpcHQ6YWxlcnQoJ1hTUycpOyI+",
	"PElNRyBTUkM9ImphdiYjeDBEO2FzY3JpcHQ6YWxlcnQoJ1hTUycpOyI+",
	"cGVybCAtZSAncHJpbnQgIjxJTUcgU1JDPWphdmEwc2NyaXB0OmFsZXJ0KCJYU1MiKT4iOycgPiBv",
	"dXQ=",
	"PElNRyBTUkM9IiAmIzE0OyBqYXZhc2NyaXB0OmFsZXJ0KCdYU1MnKTsiPg==",
	"PFNDUklQVC9YU1MgU1JDPSJodHRwOi8vaGEuY2tlcnMub3JnL3hzcy5qcyI+PC9TQ1JJUFQ+",
	"PEJPRFkgb25sb2FkISMkJSYoKSp+Ky1fLiw6Oz9AWy98XV5gPWFsZXJ0KCJYU1MiKT4=",
	"PFNDUklQVC9TUkM9Imh0dHA6Ly9oYS5ja2Vycy5vcmcveHNzLmpzIj48L1NDUklQVD4=",
	"PDxTQ1JJUFQ+YWxlcnQoIlhTUyIpOy8vPDwvU0NSSVBUPg==",
	"PFNDUklQVCBTUkM9aHR0cDovL2hhLmNrZXJzLm9yZy94c3MuanM/PCBCID4=",
	"PFNDUklQVCBTUkM9Ly9oYS5ja2Vycy5vcmcvLmo+",
	"PElNRyBTUkM9ImphdmFzY3JpcHQ6YWxlcnQoJ1hTUycpIg==",
	"PGlmcmFtZSBzcmM9aHR0cDovL2hhLmNrZXJzLm9yZy9zY3JpcHRsZXQuaHRtbCA8",
	"IjthbGVydCgnWFNTJyk7Ly8=",
	"PHUgb25jb3B5PWFsZXJ0KCk+IENvcHkgbWU8L3U+",
	"PGkgb253aGVlbD1hbGVydCgxKT4gU2Nyb2xsIG92ZXIgbWUgPC9pPg==",
	"PHBsYWludGV4dD4=",
	"aHR0cDovL2EvJSUzMCUzMA==",
	"PC90ZXh0YXJlYT48c2NyaXB0PmFsZXJ0KDEyMyk8L3NjcmlwdD4=",
	"MTtEUk9QIFRBQkxFIHVzZXJz",
	"MSc7IERST1AgVEFCTEUgdXNlcnMtLSAx",
	"JyBPUiAxPTEgLS0gMQ==",
	"JyBPUiAnMSc9JzE=",
	"JQ==",
	"Xw==",
	"LQ==",
	"LS0=",
	"LS12ZXJzaW9u",
	"LS1oZWxw",
	"JFVTRVI=",
	"L2Rldi9udWxsOyB0b3VjaCAvdG1wL2JsbnMuZmFpbCA7IGVjaG8=",
	"YHRvdWNoIC90bXAvYmxucy5mYWlsYA==",
	"JCh0b3VjaCAvdG1wL2JsbnMuZmFpbCk=",
	"QHtbc3lzdGVtICJ0b3VjaCAvdG1wL2JsbnMuZmFpbCJdfQ==",
	"ZXZhbCgicHV0cyAnaGVsbG8gd29ybGQnIik=",
	"U3lzdGVtKCJscyAtYWwgLyIp",
	"YGxzIC1hbCAvYA==",
	"S2VybmVsLmV4ZWMoImxzIC1hbCAvIik=",
	"S2VybmVsLmV4aXQoMSk=",
	"JXgoJ2xzIC1hbCAvJyk=",
	"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/PjwhRE9DVFlQRSBmb28g",
	"WyA8IUVMRU1FTlQgZm9vIEFOWSA+PCFFTlRJVFkgeHhlIFNZU1RFTSAiZmlsZTovLy9ldGMvcGFz",
	"c3dkIiA+XT48Zm9vPiZ4eGU7PC9mb28+",
	"JEhPTUU=",
	"JEVOVnsnSE9NRSd9",
	"JWQ=",
	"JXM=",
	"ezB9",
	"JSouKnM=",
	"Li4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vZXRjL3Bhc3N3ZCUwMA==",
	"Li4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vZXRjL2hvc3Rz",
	"KCkgeyAwOyB9OyB0b3VjaCAvdG1wL2JsbnMuc2hlbGxzaG9jazEuZmFpbDs=",
	"KCkgeyBfOyB9ID5fWyQoJCgpKV0geyB0b3VjaCAvdG1wL2JsbnMuc2hlbGxzaG9jazIuZmFpbDsg",
	"fQ==",
	"PDw8ICVzKHVuPSclcycpID0gJXU=",
	"KysrQVRIMA==",
	"Q09O",
	"UFJO",
	"QVVY",
	"Q0xPQ0sk",
	"TlVM",
	"QTo=",
	"Wlo6",
	"Q09NMQ==",
	"TFBUMQ==",
	"TFBUMg==",
	"TFBUMw==",
	"Q09NMg==",
	"Q09NMw==",
	"Q09NNA==",
	"RENDIFNFTkQgU1RBUlRLRVlMT0dHRVIgMCAwIDA=",
	"U2N1bnRob3JwZSBHZW5lcmFsIEhvc3BpdGFs",
	"UGVuaXN0b25lIENvbW11bml0eSBDaHVyY2g=",
	"TGlnaHR3YXRlciBDb3VudHJ5IFBhcms=",
	"SmltbXkgQ2xpdGhlcm9l",
	"SG9ybmltYW4gTXVzZXVt",
	"c2hpdGFrZSBtdXNocm9vbXM=",
	"Um9tYW5zSW5TdXNzZXguY28udWs=",
	"aHR0cDovL3d3dy5jdW0ucWMuY2Ev",
	"Q3JhaWcgQ29ja2J1cm4sIFNvZnR3YXJlIFNwZWNpYWxpc3Q=",
	"TGluZGEgQ2FsbGFoYW4=",
	"RHIuIEhlcm1hbiBJLiBMaWJzaGl0eg==",
	"bWFnbmEgY3VtIGxhdWRl",
	"U3VwZXIgQm93bCBYWFg=",
	"bWVkaWV2YWwgZXJlY3Rpb24gb2YgcGFyYXBldHM=",
	"ZXZhbHVhdGU=",
	"bW9jaGE=",
	"ZXhwcmVzc2lvbg==",
	"QXJzZW5hbCBjYW5hbA==",
	"Y2xhc3NpYw==",
	"VHlzb24gR2F5",
	"RGljayBWYW4gRHlrZQ==",
	"YmFzZW1lbnQ=",
	"SWYgeW91J3JlIHJlYWRpbmcgdGhpcywgeW91J3ZlIGJlZW4gaW4gYSBjb21hIGZvciBhbG1vc3Qg",
	"MjAgeWVhcnMgbm93LiBXZSdyZSB0cnlpbmcgYSBuZXcgdGVjaG5pcXVlLiBXZSBkb24ndCBrbm93",
	"IHdoZXJlIHRoaXMgbWVzc2FnZSB3aWxsIGVuZCB1cCBpbiB5b3VyIGRyZWFtLCBidXQgd2UgaG9w",
	"ZSBpdCB3b3Jrcy4gUGxlYXNlIHdha2UgdXAsIHdlIG1pc3MgeW91Lg==",
	"Um9zZXMgYXJlIBtbMDszMW1yZWQbWzBtLCB2aW9sZXRzIGFyZSAbWzA7MzRtYmx1ZS4gSG9wZSB5",
	"b3UgZW5qb3kgdGVybWluYWwgaHVl",
	"QnV0IG5vdy4uLhtbMjBDZm9yIG15IGdyZWF0ZXN0IHRyaWNrLi4uG1s4bQ==",
	"VGhlIHF1aWMICAgICAhrIGJyb3duIGZvBwcHBwcHBwcHBwd4Li4uIFtCZWVlZXBd",
	"UG93ZXLZhNmP2YTZj9i12ZHYqNmP2YTZj9mE2LXZkdio2Y/Ysdix2Ysg4KWjIOClo2gg4KWjIOCl",
	"o+WGlw==",
}
