package operations

import (
	"a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	"a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"sync/atomic"
	"time"
)

type AppendOperation struct {
	MailBox MailBox
	Flags   Flags

	//Size 	types.BytesLeft

	Date        Date
	SenderName  ConstantText
	From        Email
	Subject     BasicStringArg
	To          Email
	MessageId   ConstantText
	Mime        ConstantNumber
	ContentType ContentType
	Text        BasicStringArg
}

func (cmd AppendOperation) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg("APPEND-TAG-" + strconv.Itoa(int(id)))},
		Name:      "APPEND",
		Arguments: CmdArguments{cmd.MailBox, cmd.Flags, BytesLeft(0)},
		Continue: []CmdArguments{
			{
				TextLayout{
					Pattern: "Date: {date}\r\n" +
						"From: {sender} <{from}>\r\n" +
						"Subject: {subject}\r\n" +
						"To: {to}\r\n" +
						"Message-Id: {mid}\r\n" +
						"MIME-Version: {mime}\r\n" +
						"Content-Type: {contentType}\r\n" +
						"\r\n" +
						"{text}\r\n" +
						"\r\n",

					Vars: map[string]CmdArgument{
						"date":        cmd.Date,
						"sender":      cmd.SenderName,
						"from":        cmd.From,
						"subject":     cmd.Subject,
						"to":          cmd.To,
						"mid":         cmd.MessageId,
						"mime":        cmd.Mime,
						"contentType": cmd.ContentType,
						"text":        cmd.Text,
					},
				},
			},
		},
	}
}

func init() {
	AllInitializers["Append"] = func(ctx fuzz.Context, rs util.RandState) Commander {

		return AppendOperation{
			MailBox:     chooseFolder(ctx, rs),
			Flags:       generateFlags(ctx, rs),
			Date:        Date(time.Now().Format("Mon, 7 Feb 1994 21:52:25 -0800 (PST)")),
			SenderName:  "Name Eman",
			From:        ctx.Username,
			Subject:     "Just subject",
			To:          ctx.Username,
			MessageId:   text("Message-Number-" + strconv.Itoa(time.Now().Nanosecond())),
			Mime:        1.0,
			ContentType: ContentType{BasicStringArg: "TEXT/PLAIN; CHARSET=US-ASCII"},
			Text:        "This is FUZZING!",
		}

	}
}

func text(s string) ConstantText {
	return ConstantText(s)
}
