package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strings"
)

var counter uint64 = 0

var CommandDistribution = CreateDistribution(map[string]uint{
	"just-tag":    2,
	"tag-and-arg": 6,
	"arg-only":    100,
	//"change-symbol" : 1, // случайно заменяем символ в запросе
	//"add-arg" : 1,
	//"remove-arg" : 1,
})

type Commander interface {
	Command() Command
}

type Command struct {
	// The command tag. It acts as a unique identifier for this command. If empty,
	// the command is untagged.
	Tag CmdArgument
	// The command name.
	Name string
	// The command arguments.
	Arguments CmdArguments
	// Addtional lines for multiline requests
	Continue []CmdArguments
}

func (c *Command) AsString() string {
	return strings.Join([]string{
		c.Tag.AsString(),
		c.Name,
		c.Arguments.AsString(),
	}, " ")
}

func (c *Command) ContinueLines() []string {
	if c.Continue == nil {
		return []string{}
	}

	lines := make([]string, 0, len(c.Continue))
	for _, cmd := range c.Continue {
		lines = append(lines, cmd.AsString())
	}

	return lines
}

func (c *Command) Fuzz(r RandState) *Command {
	switch CommandDistribution.Peek(r) {
	case "just-tag":
		c.Tag = c.Tag.Fuzz(r)

	case "tag-and-arg":
		c.Tag = c.Tag.Fuzz(r)
		c.Arguments = c.Arguments.Fuzz(r).(CmdArguments)

	case "arg-only":
		c.Arguments = c.Arguments.Fuzz(r).(CmdArguments)

	default:
		panic("unexpected case")
	}

	if c.Continue != nil {
		for i := range c.Continue {
			c.Continue[i] = c.Continue[i].Fuzz(r).(CmdArguments)
		}

		// если наменяли тело запроса, то хорошо бы обновить
		for i, arg := range c.Arguments {
			if b, ok := arg.(BytesLeft); ok {
				b.Update(c.ContinueLines())
				// длину запроса все равно хотим фаззить, но контролируемо
				c.Arguments[i] = b.Fuzz(r)
			}

		}
	}

	return c
}
