package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strings"
)

var folderDist = CreateDistribution(map[string]uint{
	"random":    100,
	"longest":   100,
	"non-empty": 100,
	"shortest":  100,
})

func chooseFolder(ctx Context, rs RandState) MailBox {
	folder, _ := rs.PeekAnyString("select-folder", ctx.Folders)

	var lf LenFunction
	switch folderDist.Peek(rs) {
	case "random":
		lf = func(s string) int {
			return 1
		}
	case "longest":
		lf = countChildren
	case "non-empty":
		// минимум одна подпапка
		lf = func(path string) int {
			if countChildren(path) == 0 {
				return 0
			}
			return 1
		}
	case "shortest":
		// наименьшее число подпапок (всегда 0 т.к. ксть инбокс)
		lf = func(path string) int {
			return -countChildren(path)
		}
	default:
		panic("unexpected case")
	}

	if c, err := rs.PeekAnyString("choose-any", LongestString(ctx.Folders, lf)); err == nil {
		folder = c
	}

	return MailBox{
		BasicStringArg: BasicStringArg(folder),
	}
}

func countChildren(path string) int {
	return strings.Count(path, "|")
}

func generateFlags(ctx Context, rs RandState) Flags {
	count := rs.RandInt("flags", 25)

	flags := make(Flags, 0, count)
	for i := 0; i < count; i++ {
		flags = append(flags, ctx.Flags[i%len(ctx.Flags)])
	}

	return flags
}
