package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"strings"
	"sync/atomic"
)

type ListOp struct {
	Left  ListPattern
	Right ListPattern
	Name  string
}

func (cmd ListOp) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	name := strings.ToUpper(cmd.Name)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg(name + "-TAG-" + strconv.Itoa(int(id)))},
		Name:      name,
		Arguments: CmdArguments{cmd.Left, cmd.Right},
	}
}

var listFactory = func(name string) Initializer {
	return func(ctx Context, rs RandState) Commander {
		left := ListPattern{BasicStringArg: "", IsLeft: true}
		right := ListPattern{BasicStringArg: "*"}

		if rs.Bool("use-not-full-pattern") {
			folder := chooseFolder(ctx, rs)
			parts := folder.Parts()

			pivot := rs.RandInt("folder-pivot", len(parts))
			left = ListPattern{BasicStringArg: MailBoxFromParts(parts[:pivot]).BasicStringArg, IsLeft: true}
			right = ListPattern{BasicStringArg: MailBoxFromParts(parts[pivot:]).BasicStringArg}
		}

		return ListOp{
			Left:  left,
			Right: right,
			Name:  name,
		}
	}
}

func init() {
	for _, name := range []string{"List", "Lsub"} {
		AllInitializers[name] = listFactory(name)
	}
}
