package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"sync/atomic"
)

type Login struct {
	Username Email
	Password Password
}

func (cmd Login) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg("LOGIN-TAG-" + strconv.Itoa(int(id)))},
		Name:      "LOGIN",
		Arguments: CmdArguments{cmd.Username, cmd.Password},
	}
}

func init() {
	AllInitializers["Login"] = func(ctx Context, rs RandState) Commander {
		return Login{
			Username: ctx.Username,
			Password: ctx.Password,
		}
	}
}
