package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"strings"
	"sync/atomic"
)

type MailBoxOperation struct {
	MailBox MailBox
	Name    string
}

var SelectInbox = MailBoxOperation{
	MailBox: Inbox,
	Name:    "Select",
}

func (cmd MailBoxOperation) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	name := strings.ToUpper(cmd.Name)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg(name + "-TAG-" + strconv.Itoa(int(id)))},
		Name:      name,
		Arguments: CmdArguments{cmd.MailBox},
	}
}

var boxFactory = func(name string) Initializer {
	return func(ctx Context, rs RandState) Commander {
		return MailBoxOperation{
			MailBox: chooseFolder(ctx, rs),
			Name:    name,
		}
	}
}

func init() {
	for _, name := range []string{"Select", "Create", "Delete", "Examine", "Subscribe", "Unsubscribe", "Status"} {
		AllInitializers[name] = boxFactory(name)
	}
}
