package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"sync/atomic"
)

type NoArgOp struct {
	Name string
}

func (cmd NoArgOp) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg(cmd.Name + "-TAG-" + strconv.Itoa(int(id)))},
		Name:      cmd.Name,
		Arguments: CmdArguments{},
	}
}

func init() {
	for _, name := range []string{"Capability", "Noop", "Check" /*, "Close" */, "Expunge"} {
		AllInitializers[name] = func(ctx Context, rs RandState) Commander {
			return NoArgOp{Name: name}
		}
	}
}
