package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"sync/atomic"
)

type Rename struct {
	From MailBox
	To   MailBox
}

func (cmd Rename) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg("RENAME-TAG-" + strconv.Itoa(int(id)))},
		Name:      "RENAME",
		Arguments: CmdArguments{cmd.From, cmd.To},
	}
}

func init() {
	AllInitializers["Rename"] = func(ctx Context, rs RandState) Commander {
		folder := chooseFolder(ctx, rs)
		return Rename{
			From: folder,
			To:   folder,
		}
	}
}
