package operations

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/types"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strconv"
	"sync/atomic"
)

type Search struct {
	args []CmdArgument
}

func (cmd Search) Command() Command {
	id := atomic.AddUint64(&counter, 1)
	return Command{
		Tag:       TagType{BasicStringArg: BasicStringArg("SEARCH-TAG-" + strconv.Itoa(int(id)))},
		Name:      "SEARCH",
		Arguments: cmd.args,
	}
}

var CriteriaSizeDistribution = CreateDistribution(map[string]uint{
	"minimal": 100,
	"small":   100,
	"medium":  50,
	"large":   10,
	"x-large": 5,
})

func init() {
	AllInitializers["Search"] = func(ctx Context, rs RandState) Commander {
		var count int
		switch CriteriaSizeDistribution.Peek(rs) {
		case "minimal":
			count = 1
		case "small":
			count = rs.RandInt("cr-count", 4)
		case "medium":
			count = rs.RandInt("cr-count", 16)
		case "large":
			count = rs.RandInt("cr-count", 64)
		case "x-large":
			count = rs.RandInt("cr-count", 128)
		}

		criterias := make([]CmdArgument, 0, count)

		for i := 0; i < count; i++ {
			criterias = append(criterias, AnyCriteria(rs, CriteriaData{
				User:  ctx.Username,
				Flags: ctx.Flags,
			}))
		}

		return Search{args: criterias}
	}
}
