package types

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"fmt"
	"strings"
)

var LayoutDist = CreateDistribution(map[string]uint{
	"fuzz-one":  25,
	"fuzz-all":  5,
	"fuzz-some": 10,
})

type BasicStringArg string

func (b BasicStringArg) AsString() string {
	return string(b)
}

func (b BasicStringArg) Fuzz(r RandState) CmdArgument {
	return BasicStringArg(FuzzString(string(b), r))
}

type ConstantText string

func (t ConstantText) AsString() string {
	return string(t)
}

func (t ConstantText) Fuzz(r RandState) CmdArgument {
	if r.RandInt("change-constant", 100) < 20 {
		return BasicStringArg(FuzzString(string(t), r))
	}
	return t
}

type ConstantNumber float64

func (c ConstantNumber) AsString() string {
	return fmt.Sprintf("%.1f", c)
}

func (c ConstantNumber) Fuzz(r RandState) CmdArgument {
	if r.BoolUniq("change-constant") {
		if r.Bool("valid-number") {
			return ConstantNumber(r.Float64("any-float"))
		} else {
			return BasicStringArg(r.AnyString())
		}
	}
	return c
}

type TextLayout struct {
	Pattern string
	Vars    map[string]CmdArgument
}

func (layout TextLayout) AsString() string {
	result := layout.Pattern
	for k, v := range layout.Vars {
		result = strings.ReplaceAll(result, "{"+k+"}", v.AsString())
	}
	return result
}

func (layout TextLayout) Fuzz(r RandState) CmdArgument {
	var keys []string
	for k := range layout.Vars {
		keys = append(keys, k)
	}

	switch LayoutDist.Peek(r) {
	case "fuzz-one":
		k, _ := r.PeekAnyString("key-to-fuzz", keys)
		layout.Vars[k] = layout.Vars[k].Fuzz(r)
	case "fuzz-all":
		for k, v := range layout.Vars {
			layout.Vars[k] = v.Fuzz(r)
		}
	case "fuzz-some":
		for k, v := range layout.Vars {
			if r.RandInt("fuzz-this", len(layout.Vars)) < 1 {
				layout.Vars[k] = v.Fuzz(r)
			}
		}
	}
	return layout
}

type Password struct {
	BasicStringArg
}

type TagType struct {
	BasicStringArg
}
