package types

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"fmt"
)

type BytesLeft int64

var BytesLeftDistribution = CreateDistribution(map[string]uint{
	"no-changes": 100,
	"negative":   1,
	"smaller":    1,
	"any-string": 5,
	"any-symbol": 5,
	"as-float":   1,
})

func (b BytesLeft) AsString() string {
	return "{" + fmt.Sprintf("%d", b) + "}"
}

func (b BytesLeft) Fuzz(r RandState) CmdArgument {
	switch BytesLeftDistribution.Peek(r) {
	case "no-changes":
		return b
	case "negative":
		return -b
	case "smaller":
		return BytesLeft(r.RandInt("smaller-count", int(b)))
	case "any-string":
		return BasicStringArg(r.AnyString())
	case "any-symbol":
		return BasicStringArg(string(rune(r.Int64("rune"))))
	case "as-float":
		return BasicStringArg(fmt.Sprintf("%f", r.Float64("any-float")*float64(b)))
	}
	return b
}

func (b *BytesLeft) Update(data []string) {
	ns := 0
	for _, s := range data {
		ns += len(s)
	}
	*b = BytesLeft(ns)
}
