package types

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strings"
)

type CmdArgument interface {
	Fuzz(r RandState) CmdArgument
	AsString() string
}

type CmdArguments []CmdArgument

var ArgsDistribution = CreateDistribution(map[string]uint{
	"all":     100,
	"one":     3,
	"some":    3,
	"shuffle": 1,
})

type Predicate = func(int) bool

var True = func(int) bool {
	return true
}

func (args CmdArguments) Fuzz(r RandState) CmdArgument {
	var p = True

	switch ArgsDistribution.Peek(r) {
	case "shuffle":
		dest := make(CmdArguments, len(args))
		perm := r.Perm("shuffle-args", len(args))
		for i, v := range perm {
			dest[v] = args[i]
		}
		//noinspection GoAssignmentToReceiver
		args = dest
	case "all":
		p = True
	case "one":
		matched := r.RandInt("arg-idx", len(args))
		p = func(i int) bool {
			return i == matched
		}
	case "some":
		bytes := r.FastRandBytes(len(args))
		p = func(i int) bool {
			return bytes[i] < 128
		}
	default:
		panic("unexpected case")
	}

	result := make([]CmdArgument, 0)
	for i := range args {
		if p(i) {
			result = append(result, args[i].Fuzz(r))
		}
	}

	return CmdArguments(result)
}

func (args CmdArguments) AsString() string {
	return strings.Join(args.mapToString(), " ")
}

func (args CmdArguments) mapToString() []string {
	r := make([]string, len(args))
	for i, v := range args {
		r[i] = v.AsString()
	}
	return r
}
