package types

import . "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"

var ContentTypeDistribution = CreateDistribution(map[string]uint{
	"no-changes": 100,
	"any-valid":  10,
	"any-string": 1,
})

var validContentTypes = []string{
	"audio/aac",
	"application/x-abiword",
	"application/octet-stream",
	"video/x-msvideo",
	"application/vnd.amazon.ebook",
	"application/octet-stream",
	"application/x-bzip",
	"application/x-bzip2",
	"application/x-csh",
	"text/css",
	"text/csv",
	"application/msword",
	"application/vnd.ms-fontobject",
	"application/epub+zip",
	"image/gif",
	"text/html",
	"image/x-icon",
	"text/calendar",
	"application/java-archive",
	"image/jpeg",
	"application/javascript",
	"application/json",
	"audio/midi",
	"video/mpeg",
	"application/vnd.apple.installer+xml",
	"application/vnd.oasis.opendocument.presentation",
	"application/vnd.oasis.opendocument.spreadsheet",
	"application/vnd.oasis.opendocument.text",
	"audio/ogg",
	"video/ogg",
	"application/ogg",
	"font/otf",
	"image/png",
	"application/pdf",
	"application/vnd.ms-powerpoint",
	"application/x-rar-compressed",
	"application/rtf",
	"application/x-sh",
	"image/svg+xml",
	"application/x-shockwave-flash",
	"application/x-tar",
	"image/tiff",
	"video/vnd.dlna.mpeg-tts",
	"font/ttf",
	"application/vnd.visio",
	"audio/x-wav",
	"audio/webm",
	"video/webm",
	"image/webp",
	"font/woff",
	"font/woff2",
	"application/xhtml+xml",
	"application/vnd.ms-excel",
	"application/xml",
	"application/vnd.mozilla.xul+xml",
	"application/zip",
	"audio/video container	video/3gpp",
	"audio/3gpp if it doesn't contain video",
	"audio/video container	video/3gpp2",
	"audio/3gpp2 if it doesn't contain video",
	"application/x-7z-compressed",
}

type ContentType struct {
	BasicStringArg
}

func (mime ContentType) Fuzz(r RandState) CmdArgument {
	switch ContentTypeDistribution.Peek(r) {
	case "no-changes":
		return mime
	case "any-valid":
		m, _ := r.PeekAnyString("any-mime", validContentTypes)
		return BasicStringArg(m)
	case "any-string":
		return BasicStringArg(r.AnyString())
	default:
		panic("unreachable case")
	}
}
