package types

import (
	"a.yandex-team.ru/mail/imap-fuzzer/fuzz/naughty"
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
)

type Email struct {
	Name   string
	Domain string
	Zone   string
}

var EmailDistribution = CreateDistribution(map[string]uint{
	"no-changes":      10,
	"any-string":      25,
	"use-random-all":  50,
	"use-random-part": 50,
	"use-random-name": 50,
	"change-at":       1,
	"change-dot":      1,
	"naughty":         50,
})

func (email Email) Fuzz(r RandState) CmdArgument {
	at := "@"
	dot := "."

	switch EmailDistribution.Peek(r) {
	case "no-changes":
		return email

	case "any-string":
		return BasicStringArg(r.AnyString())

	case "use-random-all":
		return BasicStringArg(email.AsString()).Fuzz(r)

	case "use-random-part":
		if r.Bool("change-email-name") {
			email.Name = FuzzString(email.Name, r)
		}
		if r.Bool("change-email-domain") {
			email.Domain = FuzzString(email.Domain, r)
		}
		if r.Bool("change-email-zone") {
			email.Zone = FuzzString(email.Zone, r)
		}

	case "use-random-name":
		email.Domain = FuzzString(email.Domain, r)

	case "change-at":
		if r.Bool("just-fuzz-at") {
			at = FuzzString(at, r)
		} else {
			at = r.AnyString()
		}

	case "change-dot":
		if r.Bool("just-fuzz-dot") {
			dot = FuzzString(at, r)
		} else {
			dot = r.AnyString()
		}

	case "naughty":
		e, _ := r.PeekAnyString("email", naughty.Emails)
		return BasicStringArg(e)

	default:
		panic("unreachable case")
	}

	return BasicStringArg(email.Name + at + email.Domain + dot + email.Zone)
}

func (email Email) AsString() string {
	return email.Name + "@" + email.Domain + "." + email.Zone
}
