package types

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	"strings"
)

var FlagsDistribution = CreateDistribution(map[string]uint{
	"no-changes": 100,
	"copy":       10,
	"copy-large": 1,
	"fuzz-flag":  5,
})

type Flag struct {
	BasicStringArg
}

type Flags []Flag

func (flags Flags) AsString() string {
	arr := make([]string, len(flags))
	for i, flag := range flags {
		arr[i] = flag.AsString()
	}

	return "(" + strings.Join(arr, " ") + ")"
}

func (flags Flags) Fuzz(r RandState) CmdArgument {
	if len(flags) == 0 {
		return flags
	}

	switch FlagsDistribution.Peek(r) {
	case "no-changes":
		return flags
	case "copy":
		count := r.RandInt("copy-flags", 1024)
		return expandFlagsDim(flags, count)
	case "copy-large":
		count := r.RandInt("copy-flags", 64*1024)
		return expandFlagsDim(flags, count)
	case "fuzz-flag":
		idx := r.RandInt("peek-flag", len(flags))
		flags[idx] = Flag{BasicStringArg(FuzzString(flags[idx].AsString(), r))}
		return flags
	default:
		panic("unreachable case")
	}
}

func expandFlagsDim(flags Flags, count int) Flags {
	newFlags := make(Flags, count)
	for i := range newFlags {
		newFlags[i] = flags[i%len(flags)]
	}
	return newFlags
}
