package types

import . "a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"

type ListPattern struct {
	BasicStringArg
	IsLeft bool
}

var ListPatternDist = CreateDistribution(map[string]uint{
	"as-mailbox": 10,
	"add-*":      10,
	"make-full":  10,
	"as-string":  10, //хотим повысить вероятность, т.к. там много приятного
	"repeat":     10,
})

func (lp ListPattern) Fuzz(r RandState) CmdArgument {
	s := string(lp.BasicStringArg)
	switch ListPatternDist.Peek(r) {
	case "as-mailbox":
		mb := MailBox{lp.BasicStringArg}
		s = mb.Fuzz(r).AsString()

	case "add-*":
		count := r.RandInt("new-*", 12)
		for i := 0; i < count; i++ {
			index := r.RandInt("new-*-pos", len(s))
			symbol, _ := r.PeekAnyString("symbol", []string{"*", "%"})
			s = s[:index] + symbol + s[index:]
		}
	case "make-full":
		s, _ = r.PeekAnyString("full-symbol", []string{"*", "%", ""})
	case "as-string":
		s = FuzzString(s, r)
	case "repeat":
		break
	default:
		panic("unexpected case")

	}

	lp.BasicStringArg = BasicStringArg(s)

	switch ListPatternDist.Peek(r) {
	case "repeat":
		return lp.Fuzz(r)
	}

	return lp

}

func (lp ListPattern) AsString() string {
	if lp.IsLeft {
		return "\"" + lp.BasicStringArg.AsString() + "\""
	}
	return lp.BasicStringArg.AsString()
}
