package util

import (
	"math/rand"
	"time"
)

type CommandDist struct {
	Dist    map[string]uint `json:"dist"`
	buckets []*string
}

type Config struct {
	Name      string      `json:"name"`
	Dist      CommandDist `json:"dist"`
	Len       uint64      `json:"len"`
	StateLen  uint64      `json:"stateLen"`
	Attempts  uint64      `json:"attempts"`
	Instances uint64      `json:"instances"`
}

type Auth interface {
	Any() AuthData
}

type AuthImpl []AuthData

func (d AuthImpl) Any() AuthData {
	s := rand.NewSource(time.Now().Unix())
	r := rand.New(s)
	return d[r.Intn(len(d))]
}

type AuthData struct {
	Login    string `json:"login"`
	Password string `json:"password"`
}

//func SingleConfig(name string, len uint64, stateLen uint64, attempts uint64, instances uint64) Config {
//	return Config{
//		Name:      name,
//		Dist:      CreateDistribution(map[string]uint{name: 1}),
//		Len:       len,
//		StateLen:  stateLen,
//		Attempts:  attempts,
//		Instances: instances,
//	}
//}

func CreateDistribution(dist map[string]uint) CommandDist {
	var keys []string
	for k := range dist {
		keys = append(keys, k)
	}

	buckets := make([]*string, 0)

	for kid, key := range keys {
		for i := uint(0); i < dist[key]; i++ {
			// не хотим случайно взять указатель но local var key
			buckets = append(buckets, &keys[kid])
		}
	}

	return CommandDist{
		Dist:    dist,
		buckets: buckets,
	}
}

func (d *CommandDist) Peek(rs RandState) string {
	return *d.buckets[rs.RandInt("choose-command", len(d.buckets))]
}
