package util

import (
	"golang.org/x/text/runes"
	"golang.org/x/text/transform"
	"golang.org/x/text/unicode/norm"
	"strings"
)

type LenFunction = func(string) int

func LongestString(arr []string, length LenFunction) []string {
	if len(arr) == 0 {
		return []string{}
	}

	l := length(arr[0])
	best := []string{arr[0]}
	for _, s := range arr {
		cl := length(s)
		if cl > l {
			best = []string{s}
			l = cl
		} else if cl == l {
			best = append(best, s)
		}
	}

	return best
}

func StripCtlFromUTF8(str string) string {
	return strings.Map(func(r rune) rune {
		if r >= 32 && r != 127 {
			return r
		}
		return -1
	}, str)
}

func StripCtlAndExtFromUTF8(str string) string {
	return strings.Map(func(r rune) rune {
		if r >= 32 && r < 127 {
			return r
		}
		return -1
	}, str)
}

func StripCtlAndExtFromUnicode(str string) string {
	isOk := func(r rune) bool {
		return r < 32 || r >= 127
	}
	t := transform.Chain(norm.NFKD, runes.Remove(runes.Predicate(isOk)))
	str, _, _ = transform.String(t, str)
	return str
}
