package imap4

import (
	"io"
	"strings"
)

const (
	cr = '\r'
	lf = '\n'
)

const (
	crlf = "\r\n"
)

type StringReader interface {
	ReadString(delim byte) (line string, err error)
}

type reader interface {
	io.Reader
	io.RuneScanner
	StringReader
}

type Reader struct {
	reader
}

func NewReader(r reader) *Reader {
	return &Reader{reader: r}
}

func (r *Reader) ReadInfo() (info string, err error) {
	info, err = r.ReadString(byte(lf))
	if err != nil {
		return
	}
	info = strings.TrimSuffix(info, string(lf))
	info = strings.TrimSuffix(info, string(cr))
	info = strings.TrimLeft(info, " ")

	return
}

func (r *Reader) ReadLine() (line string, err error) {
	line, err = r.ReadString(byte(lf))
	if err != nil {
		return
	}
	return line, err
}
