package imap4

import (
	"io"
)

type flusher interface {
	Flush() error
}

// An IMAP writer.
type Writer struct {
	io.Writer
}

// Helper function to write a string to w.
func (w *Writer) writeString(s string) error {
	_, err := io.WriteString(w.Writer, s)
	return err
}

func (w *Writer) writeStringCrlf(s string) (err error) {
	err = w.writeString(s)
	if err != nil {
		return
	}
	return w.writeCrlf()
}

func (w *Writer) writeCrlf() error {
	if err := w.writeString(crlf); err != nil {
		return err
	}

	return w.Flush()
}

func (w *Writer) Flush() error {
	if f, ok := w.Writer.(flusher); ok {
		return f.Flush()
	}
	return nil
}

//func NewWriter(w io.Writer) *Writer {
//	return &Writer{Writer: w}
//}

func NewClientWriter(w io.Writer) *Writer {
	return &Writer{Writer: w}
}
