package main

import (
	. "a.yandex-team.ru/mail/imap-fuzzer/fuzz/logic"
	"a.yandex-team.ru/mail/imap-fuzzer/fuzz/util"
	. "context"
	"encoding/json"
	"flag"
	"io/ioutil"
	"log"
	"os"
	"sort"
	"time"
)

var infoLog = log.New(os.Stdout, "info: ", log.LstdFlags)
var errLog = log.New(os.Stderr, "error: ", log.LstdFlags)

func main() {
	//curl http://tus.n.yandex-team.ru/1/create_account/portal/ - create new acc

	//yandex-team-92702.96436
	//yandex-team-58011.15225
	//yandex-team-21746.38934

	var authPath string
	var cfgPath string

	flag.StringVar(&authPath, "auth", "data/auth.json", "path to auth config")
	flag.StringVar(&cfgPath, "config", "data/ro_config.json", "path to auth config")
	flag.Parse()

	configs, err := loadConfigs(cfgPath)
	if err != nil {
		panic(err)
	}

	auth, err := loadAuth(authPath)
	if err != nil {
		panic(err)
	}

	runner := NewRunner()
	ctx, _ := WithCancel(Background())

	out := make(chan ErrorCommand, 128)
	defer close(out)

	wg, progress := runner.RunAllAsync(ctx, out, configs, auth)

	go handleProgress(ctx, time.Second*1, progress)

	doneChan := make(chan struct{})
	defer close(doneChan)

	go func() {
		wg.Wait()
		doneChan <- struct{}{}
	}()

	for {
		select {
		case <-doneChan:
			for {
				select {
				case err := <-out:
					handleError(err)
				default:
					return
				}
			}
		case err := <-out:
			handleError(err)
		}
	}
}

func handleError(err ErrorCommand) {
	errLog.Println(err.Error())
}

func loadAuth(path string) (auth util.AuthImpl, err error) {
	var authData []byte
	if authData, err = ioutil.ReadFile(path); err != nil {
		return
	}

	if err = json.Unmarshal(authData, &auth); err != nil {
		return
	}

	return
}

func loadConfigs(path string) (configs []util.Config, err error) {
	var cfgData []byte
	cfgData, err = ioutil.ReadFile(path)
	if err != nil {
		return
	}
	if err = json.Unmarshal(cfgData, &configs); err != nil {
		return
	}

	for i := range configs {
		configs[i].Dist = util.CreateDistribution(configs[i].Dist.Dist)
	}

	return
}

func handleProgress(ctx Context, interval time.Duration, p map[string]*Progress) {
	var keys []string
	for k := range p {
		keys = append(keys, k)
	}
	sort.Strings(keys)

	for {
		select {
		case <-ctx.Done():
			return
		case <-time.After(interval):
			infoLog.Print("\033[2J")
			infoLog.Println("=========INFO=========")
			for _, k := range keys {
				v := p[k]
				infoLog.Println(k, " ", v.Done, "/", v.Left)
			}
			infoLog.Println("======================")
		}
	}
}
