#!/bin/bash


DELAY_LOOP=12
CRIT_USAGE_PERC=80


MEMORY_LIMIT=$(($(qloud_var QLOUD_MEMORY_LIMIT) / 1024))
PID=$(pgrep imap) || exit

MEMORY_USAGE=$(grep VmRSS /proc/$PID/status | awk '{print $2}')
MEMORY_USAGE_PERC=$((MEMORY_USAGE * 100 / MEMORY_LIMIT ))

if [ $MEMORY_USAGE_PERC -gt $CRIT_USAGE_PERC ];then
    if [ -f /tmp/imap.lock ]; then
        logger -p daemon.err "imap skip restart due to memory size"
    else
        touch /tmp/imap.lock
        /usr/bin/restart
        rm -rf /tmp/imap.lock
        logger -p daemon.err "imap restarted due to memory size: "$MEMORY_USAGE
    fi
fi
