#!/bin/bash

IPSET_TIMEOUT=43200 # 12 hours
CBB_FLAG=963        # MAILSRE-1014

function cpu_limit_fraction {
    if [[ -z "$DISABLE_CPU_LIMITS_FOR_SUBCONTAINERS" ]]; then
        fraction=$1
        awk \
            -v cores="$QLOUD_CPU_GUARANTEE" \
            -v fraction="$fraction" \
            'BEGIN {
                ret = cores * fraction;
                printf("%.1fc", ret > 0.1 ? ret : 0.1)
            }'
    else
        echo "$QLOUD_CPU_GUARANTEE"
    fi
}

if [ -v IPBLOCKER ] && [ $IPBLOCKER -eq 1 ];then
    portoctl run self/sub_ipblocker \
          respawn=true \
          isolate=false \
          user=root \
          cpu_limit=$(cpu_limit_fraction 0.1) \
          command="/app/tools/ipblocker --ipset-timeout "$IPSET_TIMEOUT" --cbb-flag "$CBB_FLAG
fi
