#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="http.requests."

function run()
{
    timetail -n 60 -r '^tskv	tskv_format=imaphttpout-log	timestamp=.{11}(\d\d:\d\d:\d\d)' $1 | head -n -1 | \
    awk -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        {
            host = get_tskv_value($0, "host")
            gsub("\\.", "_", host)
            status = get_tskv_value($0, "status")
            tm = get_tskv_value($0, "total_time")
            attempt = get_tskv_value($0, "attempt")
            if (length(host) > 0 &&
                length(status) > 0 &&
                length(tm) > 0 &&
                length(attempt) > 0) # filter malformed entries
            {
                http[host ".status." status]++
                http[host ".attempt." attempt]++
                collect_timings(tm, host, host_tm)
            }
        }
        END {
            for (metric in http) {
                print prefix metric, http[metric], ts
            }
            for (host in host_tm) {
                print prefix host ".timings", "[" host_tm[host] "]", ts
            }
        }'
}

run /var/log/imap/httpout.log
