#!/usr/bin/python
# -*- coding: UTF-8 -*-

import re
from yamail.graphite import *
from yamail.timetail import *


error_log = "/var/log/imap/error.log"


# Спиоск ошибок по типам:
FOLDERS = ['NoSuchFolderError', 'CREATE.*folder', 'No such folder', 'FolderImpl',
           'Mapped folder', 'RENAME.*folder', 'update folder', 'SELECT.*folder']
POSTGRES = ['Failed to load all details from replica']
STORAGE = ['FetchWorker', 'Failed to load message']
LOGIN = ['IMAP is disabled in settings',
         'untrusted connection for plain text auth']
AUTH_BACKEND = ['account not found',
                'Empty login and uid',
                'Invalid characters in login',
                'Bad password; account disabled',
                'expired_token',
                'BlackBox error',
                'account has been globally logged out',
                'Account disabled',
                'Operation canceled',
                'Login not found',
                'auth attempt blocked',
                'Bad password']
XIVA = ['Reached subscribe limit']
OTHERS = ['Append', 'iconv', 'parse failure']
SETTINGS = ['HttpLoader error']

# Список строк, которые игнорируем:
IGNORE = ['blackbox login not success,', 'invalid oauth scope']

# Генерируем словарь ошибок:
ERRORS = {'folders': FOLDERS, 'postgres': POSTGRES, 'storage': STORAGE,
          'login': LOGIN + AUTH_BACKEND, 'xiva': XIVA, 'settings': SETTINGS, 'others': OTHERS}
for err_type in ERRORS:
    err_list = ERRORS[err_type]
    ERRORS[err_type] = {err: 0 for err in err_list}


# Заменяем спецсимволы в названии ошибки:
def format(line):
    line = re.sub(' ', '_', line)
    line = re.sub(';', '_', line)
    line = re.sub('\.\*', '_', line)
    return line


# Парсим вывод:
unknown = 0
lines = timetail(error_log, fmt='imap')
for line in lines:
    line = line.strip()
    is_unknown = True
    parse = True

    for error in IGNORE:
        if re.search(error, line):
            parse = None

    if re.search(" error: ", line) and parse:
        for err_type in ERRORS:
            for error in ERRORS[err_type]:
                if re.search(error, line):
                    ERRORS[err_type][error] += 1
                    is_unknown = None
        if is_unknown:
            unknown += 1



for err_type in ERRORS:
    for error in ERRORS[err_type]:
        print "imap.error.%s.%s %d %d" % (err_type, format(error), ERRORS[err_type][error], timestamp)

print "imap.error.unknown %d %d" % (unknown, timestamp)
