#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
log="/var/log/imap/profiler.log"

[ -s $log ] && pa -t 60 $log | tr '[:upper:]' '[:lower:]' | awk -v ts=$ts '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    {
        requests[$2 "." $(NF-1)] += 1
        collect_timings($NF, $2 "." $(NF-1), timings)
    }

    END {
        for (i in requests) {
            print "pa.requests." i, requests[i], ts
            print "pa.timings." i, "[" timings[i] "]", ts
        }
    }'
