#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os
import re
import sys
import socket
import time
from yamail.graphite import *
from yamail.timetail import *

error_log = "/var/log/imap/error.log"


# Ошибки постргеса (не шарпея):
postgres = ['parse failure', 'role master', 'subscribe xiva',
            'load message', 'Append bySmtp', 'Macs notice']

sharpei = ['retrieve folders', 'retrieve labels']

folders = ['already existed folder', 'such folder', 'Reserved folder' ]

# Класс списка ошибок:
class Pgerr(object):

    # Создаем инстанс используя список ошибок, имя инстанса:
    def __init__(self, erlist, erclass):
        # Словарь с ошибками:
        self.edict = {}
        self.erclass = erclass
        for err in erlist:
            self.edict[err] = 0
        self.edict['unknown'] = 0

        # Словарь с ошибками папок:
        self.fdict = {}
        for err in folders:
            self.fdict[err] = 0

    # Выводим содержимое класса в формате отправки в графит:
    def graphite(self):
        for err in self.edict:
            error = re.sub(' ', '_', err)
            print("%s.%s %d %d" % (self.erclass, error, self.edict[err], timestamp))
        # Ошибки папок:
        if self.erclass == 'postgres':
            for err in self.fdict:
                error = re.sub(' ', '_', err)
                print("%s.%s %d %d" % (self.erclass + '-folders', error, self.fdict[err], timestamp))

    # Ищем в строке ошибку из списка:
    def update(self, line):
        unknown = 1
        for err in self.edict:
            if re.search(err, line):
                self.edict[err] += 1
                unknown = None
                break
        for err in self.fdict:
            if re.search(err, line):
                self.fdict[err] += 1
                unknown = None
                break
        if unknown:
            # print line
            self.edict['unknown'] += 1


# Создаем объект класса ошибок:
sharpei_errs = Pgerr(sharpei, 'sharpei')
postgres_errs = Pgerr(postgres, 'postgres')


# Компилируем регулярки для парсинга:
c_pg = re.compile(',pg]')
c_sharpei = re.compile('sharpei_client')

# Парсим тейлинг лога:
lines = timetail(error_log, fmt='imap')
for line in lines:
    if c_pg.search(line):
        if c_sharpei.search(line):
            sharpei_errs.update(line)

        else:
            postgres_errs.update(line)

sharpei_errs.graphite()
postgres_errs.graphite()
