#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os
import re
import time
from yamail.graphite import *
from yamail.timetail import *
from urlparse import urlparse
from urlparse import parse_qs

api_log = '/var/log/imap/api.log'
warning_log = '/var/log/imap/warning.log'

tailer = 'timetail -n 60 -t imap | head -n -1 '

storage_host = 'storage.mail.yandex.net'


storage_errors = ['wrong mdsResult', 'wrong bodystructure']
storage_errors = {i: 0 for i in storage_errors}

# Разбираем типы параметров gettype в запросах к стораджу:
types = {}
api_raw = timetail(api_log, fmt='imap')
for line in api_raw:
    if re.search(storage_host, line):
        url = line.split('"')[1]
        get_type = parse_qs(urlparse(url).query).get('gettype', ['None'])[0]
        is_range = parse_qs(urlparse(url).query).get('range', ['None'])[0]
        if is_range == '1':
            get_type += '-range'
        types[get_type] = types.get(get_type, 0) + 1

# print types

# Разбираем ошибки запросах к стораджу:
warning_raw = timetail(warning_log, fmt='imap')
for line in warning_raw:
    for error in storage_errors.keys():
        if re.search(error, line):
            storage_errors[error] += 1

for metric in types:
    metric_name = re.sub(' ', '_', metric)
    print("%s.%s %d %d" % ('storage.gettype', metric_name, types[metric], timestamp))

for metric in storage_errors:
    metric_name = re.sub(' ', '_', metric)
    print("%s.%s %d %d" % ('imap.error.storage', metric_name, storage_errors[metric], timestamp))
