#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

timetail -t imap -n 60 /var/log/imap/timing.log | head -n -1 | awk -v ts=$(date +%s) '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    {
        $0 = tolower($0);

        match($0, /command="[^ ]+( uid | )([^ "]+)/, cmd);
        match($0, /tm=([0-9\.]+)/, tm);

        command_cnt[cmd[2]]++
        command_cnt["total"]++
        collect_timings(tm[1], cmd[2], command_tm)
    }

    END {
        for (command in command_cnt) {
            print "commands.count." command, command_cnt[command], ts
        }
        for (command in command_tm) {
            print "commands.timings." command, "[" command_tm[command] "]", ts
        }
    }'