#!/usr/bin/python
# -*- coding: UTF-8 -*-

import re
from yamail.timetail import timetail
from yamail.graphite import timestamp
from collections import defaultdict


typed_log = "/var/log/imap/typed.log"

command_statuses = defaultdict(lambda: defaultdict(int))
command_timings = defaultdict(list)

# Словарь в котором, для команды каждого типа будет перечислен список uid-ов:
uid_command_statuses = defaultdict(set)


for line  in timetail(typed_log, fmt="tskv2")[:-1]:
    if line.get("type") != "command":
        continue

    status = line.get("status")
    command_name = line.get("command_name").lower()
    command_name = re.sub("uid ", "", command_name)
    command_statuses[command_name][status] += 1
    command_statuses["total"][status] += 1

    command_timings[command_name].append(float(line.get("total_time")))

    uid = line.get("uid")
    if uid and line.get("type") == "command":
        uid_command_statuses[status].add(uid)

for command, statuses in command_statuses.iteritems():
    for status, count in statuses.iteritems():
        print "commands.statuses.%s.%s %d %d" % (command, status, count, timestamp)

for status, uids in uid_command_statuses.iteritems():
    print "users.commands.statuses.%s %d %d" % (status, len(uids), timestamp)

for command, timings in command_timings.iteritems():
    # Пробел используется как разделитель между именем метрики, ее значением и таймстэмпом в /var/log/metrics/. И поэтому его приходится вырезать из значения
    timings = str(timings)
    timings = re.sub(" ", "", timings)
    print "commands.timings.%s %s %d" % (command, timings, timestamp)

