#pragma once

#include "append.h"
#include <backend/thread_pool.h>
#include <backend/backend.h>
#include <backend/backend_service.h>

namespace yimap { namespace backend {

struct AppendBackendImpl : AppendBackend
{
    AppendBackendImpl(backend::BackendServicePtr service, ImapContextPtr context)
        : context(context), pool(service->getThreadPool())
    {
    }

    Future<AppendResult> append(AppendRequest&& request) override
    {
        // Wrap synchronous smtp send by thread pool.
        auto ctx = boost::make_shared<yplatform::task_context>(*context);
        ctx->deadline_from_now(Seconds(context->settings->appendSettings.smtpTimeout));
        std::function<AppendResult()> task =
            [context = context, request = std::move(request)]() mutable -> AppendResult {
            auto append = std::make_shared<Append>(context);
            auto future = append->append(std::move(request)); // Actually it is synchronous.
            return future.get();
        };
        return pool->post<decltype(task), AppendResult>(ctx, task);
    }

    ImapContextPtr context;
    ThreadPoolPtr pool;
};

}}
