#ifndef __SMTP_PROTOCOL__
#define __SMTP_PROTOCOL__

#include <vector>
#include <string>

#include <backend/append/sock_wrap.h>
#include <common/log/logger.h>

namespace yimap { namespace mysmtp {

enum
{
    SC_OK = 0,
    SC_FAIL_ENVELOPE,
    SC_FAIL_DATA
};

struct Recipient
{
    Recipient(const std::string& email, bool requestDsn = false)
    {
        email_ = email;
        requestDsn_ = requestDsn;
    }

    std::string email_;
    bool requestDsn_;
};

typedef std::vector<Recipient> RecipientList;

struct SmtpResult
{
    int code;
    std::string text;
    SmtpResult() : code(0), text()
    {
    }
};

struct SmtpParameters
{
    bool _8bitmime;
    bool pipelining;
    bool excode;
    bool dsn;
    SmtpParameters() : _8bitmime(false), pipelining(false), excode(false), dsn(false)
    {
    }
};

class SmtpClient
{
public:
    typedef enum
    {
        smtp_mode = 0,
        lmtp_mode
    } mode;
    SmtpClient(yimap::Logger& logger) : logger(&logger), lmtp(false)
    {
    }
    SmtpClient(yimap::Logger& logger, mode _lmtp) : logger(&logger), lmtp(static_cast<bool>(_lmtp))
    {
    }
    virtual ~SmtpClient()
    {
        close_connection();
    }
    int connect(const std::string& hostname, int port, int timeout, bool ipv6);
    int sendMail(
        const std::string& from,
        const RecipientList& to,
        const std::string& data,
        const std::string& envId = "");
    const std::string& getSavedMid() const
    {
        return saved_mid;
    }
    const std::string& getSavedUid() const
    {
        return saved_uid;
    }
    void close();

protected:
    virtual int makeConnection(const std::string& host, int port, int timeout);
    virtual void close_connection();
    virtual int sendQuery(const std::string& data);
    virtual int readLine(std::string& line);

private:
    yimap::Logger* logger;

    TConnectionInfo conn_info;
    std::string buffer;
    std::string last_error;
    std::string saved_mid;
    std::string saved_uid;
    std::string remote_smtp_host;
    SmtpParameters params;
    bool lmtp;

    int connect_(const std::string& hostname, int port, int timeout);
    int sendEnvelope(
        const std::string& from,
        const RecipientList& recipients,
        RecipientList::const_iterator& to_failed,
        const std::string& envId);
    int sendMailData(const std::string& data);
    SmtpResult query(const std::string& data);
    SmtpResult readResult();
    int readBuffer();
    std::string error_msg(int error_code);
};

}}

#endif //  __SMTP_PROTOCOL__
