#ifndef SOCK_WRAP_H
#define SOCK_WRAP_H

namespace yimap {

struct TConnectionInfo
{
    int socket = -1;
    int timeout = 0;
    bool ipv6 = false;
};

ssize_t sock_wrap_connect(
    const char* hostname,
    const int port,
    const int timeout,
    TConnectionInfo& info);

ssize_t sock_wrap_write(const char* buf, ssize_t len, TConnectionInfo& info);

ssize_t sock_wrap_read(char* buf, ssize_t len, TConnectionInfo& info);

void sock_wrap_close(TConnectionInfo& info);

}

#endif
