#pragma once

#include "backend_types.h"
#include "backend.h"
#include "thread_pool.h"

#include <memory>

namespace yimap { namespace backend {

class BackendService
{
public:
    virtual ~BackendService()
    {
    }

    virtual UserJournalPtr createJournal(
        const string& uid,
        const string& clientIp,
        const string& mdb,
        const string& suid,
        const string& service = "yserver_imap") = 0;

    virtual PgServicePtr createPgService(
        const ShortSessionInfo& sessionInfo,
        bool replica,
        const std::string& service = "yserver_imap") = 0;

    virtual ThreadPoolPtr getThreadPool() = 0;
};

using BackendServicePtr = std::shared_ptr<BackendService>;

} // namespace backend
} // namespace yimap
