#pragma once

#include <backend/events.h>
#include <common/imap_context.h>
#include <common/types.h>

namespace yimap {

class ImapEventHandler
{
public:
    virtual ~ImapEventHandler() = default;
    virtual bool onEvent(ImapEventPtr) = 0;
};
typedef std::shared_ptr<ImapEventHandler> EventHandlerPtr;
typedef std::weak_ptr<ImapEventHandler> WeakEventHandlerPtr;

class WeakHandlerProxy : public ImapEventHandler
{
public:
    WeakHandlerProxy(WeakEventHandlerPtr handler) : handler(handler)
    {
    }
    virtual bool onEvent(ImapEventPtr eventPtr)
    {
        auto strongHandler = handler.lock();
        if (strongHandler) return strongHandler->onEvent(eventPtr);
        else
            return false;
    }

private:
    WeakEventHandlerPtr handler;
};

}