#pragma once

#include "message_loader.h"
#include "body_structure_loader.h"
#include "../backend.h"

namespace yimap::mbody {

struct MbodyBackendImpl : backend::MbodyBackend
{
    MbodyBackendImpl(ImapContextPtr context) : context(context)
    {
    }

    void loadMessage(
        const std::string& stid,
        const std::string& part,
        const macs::MimeParts& mimeParts,
        const Handler& handler) override
    {
        auto loader = std::make_shared<MessageLoader>(context, stid, mimeParts);
        loader->load(part, true, true, handler);
    }

    void loadHeader(
        const std::string& stid,
        const std::string& part,
        const macs::MimeParts& mimeParts,
        const Handler& handler) override
    {
        auto loader = std::make_shared<MessageLoader>(context, stid, mimeParts);
        loader->load(part, true, false, handler);
    }

    void loadBody(
        const std::string& stid,
        const std::string& part,
        const macs::MimeParts& mimeParts,
        const Handler& handler) override
    {
        auto loader = std::make_shared<MessageLoader>(context, stid, mimeParts);
        loader->load(part, false, true, handler);
    }

    Future<std::shared_ptr<BodyStructure>> loadBodyStructure(
        const string& stid,
        const macs::MimeParts& mimeParts,
        const std::vector<string>& rawHeadersList) override
    {
        BodystructureLoader loader(rawHeadersList, context, stid, mimeParts);
        return loader.load();
    }

    ImapContextPtr context;
};

}
