#pragma once

#include <backend/mbody/types.h>
#include <backend/backend_types.h>
#include <common/imap_context.h>
#include <common/log/logger.h>
#include <common/types.h>
#include <common/settings.h>
#include <backend/mbody/storage/message_storage.h>

namespace yimap { namespace mbody {

class MessageLoader : public std::enable_shared_from_this<MessageLoader>
{
public:
    using handler_type = std::function<void(const string& err, StringPtr msg)>;

    MessageLoader(
        ImapContextPtr context,
        const std::string& stid,
        const macs::MimeParts& mimeParts);

    void load(const std::string& part, bool withHeader, bool withBody, const handler_type& handler);

protected:
    struct Result
    {
        std::string msg;
        size_t rfcSize;
        std::string err;
    };

    Future<Result> loadFromMDS(const std::string& part, bool withHeader, bool withBody);
    void doLoadFromMDS(
        Promise<Result> promise,
        const std::string& part,
        bool withHeader,
        bool withBody,
        std::string err,
        std::string hid);

    std::string prepareHid(const std::string& imapHid);

protected:
    ImapContextPtr context;
    std::string stid;
    MessageStoragePtr messageStorage;
};

} // namespace mbody
} // namespace yimap
