#pragma once

#include <macs/mime_part.h>
#include <common/imap_context.h>
#include <common/types.h>
#include <backend/mbody/types.h>

namespace yimap { namespace mbody {

class MessageStorage
{
public:
    template <typename Result>
    using Handler = std::function<void(std::string err, Result)>;

    struct HeaderStruct
    {
        std::string contentType;
        std::string contentSubtype;
    };

    virtual ~MessageStorage()
    {
    }

    virtual void getWhole(std::string hid, Handler<std::string> handler) const = 0;
    virtual void getHeaders(std::string hid, Handler<std::string> handler) const = 0;
    virtual void getBody(std::string hid, Handler<std::string> handler) const = 0;
    virtual void getHeaderStruct(std::string hid, Handler<HeaderStruct> handler) const = 0;
    virtual void getMessageSize(Handler<std::size_t> handler) const = 0;
};

using MessageStoragePtr = std::shared_ptr<MessageStorage>;

class MessageStorageFactory
{
public:
    virtual ~MessageStorageFactory()
    {
    }

    virtual MessageStoragePtr create(
        ImapContextPtr,
        const std::string& stid,
        const macs::MimeParts&) const = 0;
};

} // namespace mbody
} // namespace yimap
