#pragma once

#include <backend/mbody/types.h>

#include <mimeparser/part.h>

namespace yimap { namespace mbody {

class MessageStorageString : public mulca_mime::part
{
public:
    MessageStorageString(ConstStringPtr _content, const std::string& _prefix, int _inlineLevel);
    ~MessageStorageString();

    MetaAttributesPtr getHeaderStruct(const std::string& hid);
    MetaLevelPtr getBodyStruct(const std::string& hid);
    StringPtr getHeader(const std::string& hid);
    StringPtr getBody(const std::string& hid);
    StringPtr getWhole();
    size_t getRfcSize() const;

private:
    int doParse();
    void splitToParts(const part& p, const std::string& id);

private:
    ConstStringPtr content;
    MetaParts meta;
    string prefix;
    int inlineLevel;
    bool parsed;
};

typedef std::shared_ptr<MessageStorageString> MessageStorageStringPtr;
typedef std::map<std::string, MessageStorageStringPtr> InlineMessages;

} // namespace mbody
} // namespace yimap
