#pragma once

#include <common/types.h>
#include <common/types.h>

#include <list>
#include <map>

namespace yimap {

namespace mbody {

struct asNumCmp
{
    bool operator()(const std::string& s1, const std::string& s2) const;
};

} // namespace mbody

using MetaAttributes = std::map<std::string, std::string>;
using MetaAttributesPtr = std::shared_ptr<MetaAttributes>;

using MetaParts = std::map<std::string, MetaAttributes, mbody::asNumCmp>;
using MetaPartsPtr = std::shared_ptr<MetaParts>;
using ConstMetaPartsPtr = std::shared_ptr<const MetaParts>;

using MetaLevel = std::list<std::string>;
using MetaLevelPtr = std::shared_ptr<MetaLevel>;

enum MAPolicy
{
    policyDefault,
    policyAttachment,
};

struct StorageSettings
{
    std::string stidTruncatePrefix;
    std::string extraAttrs;
    size_t cacheSize = 0;
};

using StorageSettingsConstPtr = std::shared_ptr<const StorageSettings>;

} // namespace yimap
