#ifndef _YIMAP_BACKEND_META_PG_PG_EXPUNGE_H_
#define _YIMAP_BACKEND_META_PG_PG_EXPUNGE_H_

#include <backend/meta_pg/pg_worker.h>

#include <macs/hooks.h>
#include <macs/envelopes_repository.h>
#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace yimap { namespace backend {

namespace ph = std::placeholders;

class PgExpunge : public PgWorker
{
public:
    using YieldCtx = yplatform::yield_context<PgExpunge>;

    FolderRef folder;
    UidMapPtr messages;
    SmidListPtr mids;
    std::shared_ptr<Chunker<SmidList>> chunker;
    mail_errors::error_code ec;
    unsigned revision;
    Promise<void> promise;

    PgExpunge(PgBackend& backend) : PgWorker(backend)
    {
    }

    void operator()(YieldCtx yieldCtx)
    {
        reenter(yieldCtx)
        {
            mids = messages->toSmidList();
            chunker = std::make_shared<Chunker<SmidList>>(mids, settings->maxDBChunkSize);
            while (!chunker->empty())
            {
                yield pg->envelopes().remove(chunker->next(), yieldCtx.capture(ec, revision));
                if (ec)
                {
                    throw ExpungeError(folder.info().name, "onUpdateFlags error " + ec.message());
                }
            }
            promise.set();
        }
    }

    void operator()(YieldCtx::exception_type exception)
    {
        promise.set_exception(exception);
    }
};

}} // namespace

#include <yplatform/unyield.h>

#endif // _YIMAP_BACKEND_META_PG_PG_EXPUNGE_H_
