#pragma once

#include <backend/meta_pg/pg_worker.h>
#include <macs/envelopes_repository.h>
#include <macs/mime_part.h>
#include <yplatform/util/sstream.h>

namespace yimap { namespace backend {

struct PgMimes : PgWorker
{
    PgMimes(PgBackend& backend) : PgWorker(backend)
    {
    }

    Future<BodyMetadataByMid> loadBodyMetadata(const SmidList& mids)
    {
        Promise<BodyMetadataByMid> promise;
        envelopesRepo().getMimesWithDeleted(
            mids, [=, capture_self](auto err, auto mimesWithMids) mutable {
                if (err)
                {
                    return promise.set_exception(BackendError(err.full_message()));
                }
                BodyMetadataByMid res;
                for (auto&& [mid, stid, mimes] : mimesWithMids)
                {
                    res[mid] = BodyMetadata{ stid, mimes };
                }
                promise.set(res);
            });
        return promise;
    }
};
} // namespace backend
} // namespace yimap
