#include "pg_worker.h"
#include <backend/meta_pg/pg_backend.h>
#include <backend/meta_common/helpers.h>

namespace yimap { namespace backend {

PgWorker::PgWorker(PgBackend& backend)
    : backend(backend)
    , context(backend.getContext())
    , logger(context->sessionLogger)
    , settings(context->settings)
    , pg(backend.createPgService(false))
{
}

::macs::Service& PgWorker::pgMaster()
{
    if (!context->sessionState.selectedFolder.readOnly())
    {
        return *pg;
    }
    return pgReplica();
}

::macs::Service& PgWorker::pgReplica()
{
    if (!pgReplicaService)
    {
        pgReplicaService = backend.createPgService(true);
    }
    return *pgReplicaService;
}

::macs::Revision PgWorker::replicaRevision()
{
    if (knownReplicaRevision == ::macs::NULL_REVISION)
    {
        // XXX sync read/write using IOService
        // TODO don't exec concurrent requests
        foldersRepo(ReplicaState::UseReplica)
            .getMailboxRevision([=, capture_self](auto err, auto rev) {
                if (!err) knownReplicaRevision = rev;
            });
    }
    return knownReplicaRevision;
}

//-----------------------------------------------------------------------------
// PG helpers

MessageData convertPgEnvelope(
    const ::macs::ImapEnvelope& message,
    const ::macs::LabelSet& imapFlags)
{
    MessageData msg(static_cast<uint32_t>(message.uid), message.mid);
    msg.num = static_cast<uint32_t>(message.num);
    msg.modseq = static_cast<uint32_t>(message.modseq);
    msg.time = message.receivedDate;
    convertFlags(imapFlags, message.labels, msg.flags);
    return msg;
}

MessagesVectorPtr convertPgChanges(
    const ::macs::ImapEnvelopeChangesChunk& changes,
    const ::macs::LabelSet& imapFlags)
{
    auto result = std::make_shared<MessagesVector>();
    result->reserve(changes.size());
    for (auto msg : changes)
    {
        MessageData message = convertPgEnvelope(msg.envelope, imapFlags);

        // Нужно уменьшить модсек, поскольку в постгресе он всегда на 1 больше чем в оракле
        if (message.modseq > 0) message.modseq--;

        message.deleted = msg.deleted;
        message.baseUid = msg.baseId;
        message.offset = msg.offset;

        if (message.uid == 0 && message.deleted) message.deleted = false;

        result->push_back(message);
    }
    return result;
}

} // namespace backend
} // namespace yimap
